/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdviceFactory;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdvicePackage;
import org.eclipse.papyrus.infra.emf.types.constraints.ReferencePermission;
import org.eclipse.papyrus.infra.filters.FiltersPackage;
import org.eclipse.papyrus.infra.filters.provider.FilteredElementItemProvider;

public class ReferencePermissionItemProvider
extends FilteredElementItemProvider {
    public ReferencePermissionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPermittedPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPermittedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ReferencePermission_permitted_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ReferencePermission_permitted_feature", "_UI_ReferencePermission_type"), (EStructuralFeature)ConstraintAdvicePackage.Literals.REFERENCE_PERMISSION__PERMITTED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        ReferencePermission referencePermission = (ReferencePermission)object;
        return this.getString("_UI_ReferencePermission_type") + " " + this.getPermissionModifier(referencePermission);
    }

    protected String getPermissionModifier(ReferencePermission referencePermission) {
        return this.getString(referencePermission.isPermitted() ? "_UI_ReferencePermission_granted" : "_UI_ReferencePermission_denied");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ReferencePermission.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.FILTERED_ELEMENT__FILTER, ConstraintAdviceFactory.eINSTANCE.createElementTypeFilter()));
    }
}

