/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.internationalization.common.editor.IInternationalizationEditor;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationModelResource;
import org.eclipse.papyrus.infra.internationalization.utils.QualifiedNameUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class PreferencePartLabelSynchronizer {
    private IPreferenceStore preferenceStore;
    private EObject graphicalEObject;
    private IInternationalizationEditor editorPart;
    private InternationalizationModelResource modelResource;
    private final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("useInternationalization") || event.getProperty().equals("language")) {
                PreferencePartLabelSynchronizer.this.editorPart.modifyPartName(PreferencePartLabelSynchronizer.this.getLabel(PreferencePartLabelSynchronizer.this.graphicalEObject));
                PreferencePartLabelSynchronizer.this.editorPart.refreshEditorPart();
            }
        }
    };

    public PreferencePartLabelSynchronizer(IPreferenceStore preferenceStore, EObject graphicalEObject, IInternationalizationEditor editorPart, InternationalizationModelResource modelResource) {
        this.editorPart = editorPart;
        this.modelResource = modelResource;
        this.graphicalEObject = graphicalEObject;
        this.setPreferenceStore(preferenceStore);
    }

    public void setPreferenceStore(IPreferenceStore preferenceStore) {
        if (preferenceStore != null) {
            preferenceStore.removePropertyChangeListener(this.propertyListener);
            this.preferenceStore = preferenceStore;
            this.editorPart.modifyPartName(this.getLabel(this.graphicalEObject));
            preferenceStore.addPropertyChangeListener(this.propertyListener);
        }
    }

    public void dispose() {
        this.editorPart = null;
        this.modelResource = null;
        if (this.preferenceStore != null) {
            this.preferenceStore.removePropertyChangeListener(this.propertyListener);
        }
    }

    protected String getLabel(EObject object) {
        String value = "";
        if (object instanceof Table) {
            value = this.getTableLabel((Table)object);
        } else if (object instanceof Diagram) {
            value = this.getDiagramLabel((Diagram)object);
        }
        return value;
    }

    protected String getTableLabel(Table table) {
        String result = null;
        EObject tableOwner = table.getOwner();
        if (tableOwner == null) {
            tableOwner = table.getContext();
        }
        if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)tableOwner)) {
            result = this.modelResource.getValueForEntryKey(tableOwner.eResource().getURI(), (EObject)table);
        }
        return result != null ? result : table.getName();
    }

    protected String getDiagramLabel(Diagram diagram) {
        String result = null;
        if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)QualifiedNameUtils.getOwner(diagram))) {
            result = this.modelResource.getValueForEntryKey(diagram.eResource().getURI(), (EObject)diagram);
        }
        return result != null ? result : diagram.getName();
    }
}

