/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.architecture.Activator;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.util.FormattableADElement;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.InternalArchitectureDomainMerger;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;

public class ArchitectureDomainMerger
implements Cloneable {
    private ResourceSet resourceSet;
    private ResourceSet mergedResourceSet;
    private Collection<URI> extensionModels;
    private Collection<URI> preferenceModels;
    private Collection<ArchitectureDomain> dynamicDomains;
    private Collection<ArchitectureDomain> loadedDomains;
    private Collection<MergedArchitectureDomain> mergedDomains;
    private Map<String, Object> idCache;

    ArchitectureDomainMerger() {
    }

    Collection<URI> getExtensionModels() {
        return this.extensionModels;
    }

    public void setExtensionModels(Collection<URI> models) {
        ArchitectureDomainMerger.logf("Extension Architecture Domain models changed: %s.", models);
        this.extensionModels = models;
        this.reset();
    }

    Collection<URI> getPrefereceModels() {
        return this.preferenceModels;
    }

    public void setPreferenceModels(Collection<URI> models) {
        ArchitectureDomainMerger.logf("Preference Architecture Domain models changed: %s.", models);
        this.preferenceModels = models;
        this.reset();
    }

    Collection<ArchitectureDomain> getDynamicDomains() {
        return this.dynamicDomains;
    }

    public void setDynamicDomains(Collection<ArchitectureDomain> domains) {
        ArchitectureDomainMerger.logf("Dynamic Architecture Domains changed: %s.", FormattableADElement.wrap(domains));
        this.dynamicDomains = domains;
        this.reset();
    }

    public Collection<MergedArchitectureDomain> getDomains() {
        this.init();
        return Collections.unmodifiableCollection(this.mergedDomains);
    }

    public MergedArchitectureContext getArchitectureContextById(String id) {
        this.init();
        Object found = this.idCache.get(id);
        return found instanceof MergedArchitectureContext ? (MergedArchitectureContext)((Object)found) : null;
    }

    public MergedArchitectureViewpoint getArchitectureViewpointById(String id) {
        this.init();
        Object found = this.idCache.get(id);
        return found instanceof MergedArchitectureViewpoint ? (MergedArchitectureViewpoint)((Object)found) : null;
    }

    public RepresentationKind getRepresentationKindById(String id) {
        this.init();
        Object found = this.idCache.get(id);
        return found instanceof RepresentationKind ? (RepresentationKind)found : null;
    }

    public ArchitectureDomainMerger clone() {
        ArchitectureDomainMerger clone = new ArchitectureDomainMerger();
        clone.setExtensionModels(this.extensionModels);
        clone.setPreferenceModels(this.preferenceModels);
        return clone;
    }

    private synchronized void reset() {
        ArchitectureDomainMerger.log("Resetting the Architecture Domains.");
        if (this.resourceSet != null) {
            EMFHelper.unload((ResourceSet)this.resourceSet);
        }
        if (this.mergedResourceSet != null) {
            EMFHelper.unload((ResourceSet)this.mergedResourceSet);
        }
        this.resourceSet = null;
        this.mergedResourceSet = null;
        this.loadedDomains = null;
        this.mergedDomains = null;
        this.idCache = null;
    }

    static void log(String message) {
        Activator.log.trace("models", message);
    }

    static void logf(String pattern, Object arg) {
        if (Activator.log.isTraceEnabled("models")) {
            Activator.log.trace("models", String.format(pattern, FormattableADElement.wrap((Object)arg)));
        }
    }

    static void logf(String pattern, Object arg1, Object arg2) {
        if (Activator.log.isTraceEnabled("models")) {
            Activator.log.trace("models", String.format(pattern, FormattableADElement.wrap((Object)arg1), FormattableADElement.wrap((Object)arg2)));
        }
    }

    synchronized void init() {
        if (this.mergedDomains != null) {
            return;
        }
        ArchitectureDomainMerger.log("Initializing the Architecture Domains.");
        Collection<ArchitectureDomain> domains = this.getLoadedArchitectureDomains();
        this.mergedDomains = new ArrayList<MergedArchitectureDomain>();
        ArchitectureDomainMerger.log("Merging the Architecture Domains.");
        InternalArchitectureDomainMerger merger = InternalArchitectureDomainMerger.newInstance();
        Iterables.addAll(this.mergedDomains, merger.mergeDomains(domains));
        if (!this.mergedDomains.isEmpty()) {
            this.mergedResourceSet = this.mergedDomains.iterator().next().getAdapter(ResourceSet.class);
            this.mergedResourceSet.getResources().removeIf(res -> !res.isLoaded() || res.getContents().isEmpty());
        }
        ArchitectureDomainMerger.log("Indexing the Architecture Domains.");
        this.buildCache();
    }

    private synchronized void initResourceSet() {
        if (this.loadedDomains != null) {
            return;
        }
        ArchitectureDomainMerger.log("Loading the Architecture Domains from source models.");
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.setURIConverter(ResourceUtils.createWorkspaceAwareURIConverter());
        this.resourceSet.setPackageRegistry(ResourceUtils.createWorkspaceAwarePackageRegistry());
        this.loadedDomains = new ArrayList<ArchitectureDomain>();
        Stream<URI> modelURIs = Stream.empty();
        if (this.extensionModels != null) {
            modelURIs = Stream.concat(modelURIs, this.extensionModels.stream());
        }
        if (this.preferenceModels != null) {
            modelURIs = Stream.concat(modelURIs, this.preferenceModels.stream());
        }
        modelURIs.map(arg_0 -> ((URIConverter)this.resourceSet.getURIConverter()).normalize(arg_0)).distinct().forEach(model -> {
            ArchitectureDomain domain = this.loadDomain(this.resourceSet.createResource(model));
            if (domain != null) {
                this.loadedDomains.add(domain);
            }
        });
        if (this.dynamicDomains != null) {
            for (ArchitectureDomain domain : this.dynamicDomains) {
                if (domain == null) continue;
                this.loadedDomains.add(domain);
            }
        }
    }

    private ArchitectureDomain loadDomain(Resource resource) {
        try {
            ArchitectureDomainMerger.logf("Loading Architecture resource %s.", resource.getURI());
            resource.load(null);
        }
        catch (IOException e) {
            ArchitectureDomainMerger.logf("Exception loading Architecture resource %s: %s", resource.getURI(), e.getMessage());
            return null;
        }
        EObject content = (EObject)resource.getContents().get(0);
        if (content instanceof ArchitectureDomain) {
            return (ArchitectureDomain)content;
        }
        Activator.log.warn("file " + String.valueOf(resource.getURI()) + " is not an architecture model");
        return null;
    }

    private void buildCache() {
        this.idCache = new HashMap<String, Object>();
        for (MergedArchitectureDomain domain : this.mergedDomains) {
            for (MergedArchitectureContext context : domain.getContexts()) {
                this.idCache.put(context.getId(), (Object)context);
                for (MergedArchitectureViewpoint viewpoint : context.getViewpoints()) {
                    this.idCache.put(viewpoint.getId(), (Object)viewpoint);
                }
                if (!(context instanceof MergedArchitectureDescriptionLanguage)) continue;
                MergedArchitectureDescriptionLanguage language = (MergedArchitectureDescriptionLanguage)context;
                for (RepresentationKind representationKind : language.getRepresentationKinds()) {
                    this.idCache.put(representationKind.getId(), representationKind);
                }
            }
        }
    }

    Collection<ArchitectureDomain> getLoadedArchitectureDomains() {
        this.initResourceSet();
        return Collections.unmodifiableCollection(this.loadedDomains);
    }
}

