/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.advices.stereotypereferencelink;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.diagram.common.stereotype.IStereotypePropertyReferenceEdgeAdvice;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.papyrus.uml.types.core.advices.stereotypepropertyreferenceedgeadvice.StereotypePropertyReferenceEdgeAdviceConfiguration;
import org.eclipse.papyrus.uml.types.core.commands.EditStereotypePropertyReferenceCommand;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class StereotypePropertyReferenceEdgeAdviceEditHelperAdvice
extends AbstractEditHelperAdvice
implements IStereotypePropertyReferenceEdgeAdvice {
    protected StereotypePropertyReferenceEdgeAdviceConfiguration configuration;
    protected String stereotypeQualifiedName;
    protected String featureToSet;
    protected String edgeLabel;

    public StereotypePropertyReferenceEdgeAdviceEditHelperAdvice(StereotypePropertyReferenceEdgeAdviceConfiguration configuration) {
        if (configuration != null) {
            this.configuration = configuration;
            this.stereotypeQualifiedName = this.configuration.getStereotypeQualifiedName();
            this.featureToSet = this.configuration.getFeatureToSet();
            this.edgeLabel = this.configuration.getEdgeLabel();
        }
    }

    protected ICommand getBeforeEditContextCommand(GetEditContextRequest request) {
        GetEditContextCommand command = new GetEditContextCommand(request);
        command.setEditContext(request.getEditHelperContext());
        return command;
    }

    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateRelationshipRequest) {
            if (this.configuration == null) {
                return false;
            }
            EObject source = ((CreateRelationshipRequest)request).getSource();
            EObject target = ((CreateRelationshipRequest)request).getTarget();
            if (target == null && source instanceof Element) {
                return ElementUtil.hasStereotypeApplied((Element)((Element)source), (String)this.stereotypeQualifiedName);
            }
            return this.canCreate(source, target);
        }
        return true;
    }

    protected ICommand getAfterCreateRelationshipCommand(CreateRelationshipRequest request) {
        boolean noSourceAndTarget;
        IdentityCommand command = null;
        EObject source = request.getSource();
        EObject target = request.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (!noSourceOrTarget && !this.canCreate(source, target)) {
            command = UnexecutableCommand.INSTANCE;
        } else if (noSourceOrTarget && !noSourceAndTarget) {
            command = IdentityCommand.INSTANCE;
        } else {
            command = new CompositeCommand("Create stereotype property reference link");
            ((CompositeCommand)command).add((IUndoableOperation)new EditStereotypePropertyReferenceCommand("Set stereotype property reference", request, this.configuration));
        }
        return command;
    }

    private boolean canCreate(EObject source, EObject target) {
        Stereotype sourceStereotype;
        Property attribute;
        boolean canCreate = false;
        if (source instanceof Element && target instanceof Element && ElementUtil.hasStereotypeApplied((Element)((Element)source), (String)this.stereotypeQualifiedName) && (attribute = (sourceStereotype = ((Element)source).getApplicableStereotype(this.stereotypeQualifiedName)).getAttribute(this.featureToSet, null)) != null) {
            Type targetType = attribute.getType();
            if (targetType instanceof Stereotype) {
                canCreate = ElementUtil.hasStereotypeApplied((Element)((Element)target), (String)targetType.getQualifiedName());
            } else {
                EClassifier metaclass;
                EObject stereotypeApplication = ((Element)source).getStereotypeApplication(UMLUtil.getAppliedSubstereotype((Element)((Element)source), (Stereotype)sourceStereotype));
                EStructuralFeature eStructuralFeature = stereotypeApplication.eClass().getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)this.featureToSet));
                if (eStructuralFeature != null && (metaclass = eStructuralFeature.getEType()) instanceof EClassifier) {
                    canCreate = metaclass.isInstance((Object)target);
                }
            }
        }
        return canCreate;
    }

    public String getFeatureToSet() {
        return this.featureToSet;
    }

    public String getStereotypeQualifiedName() {
        return this.stereotypeQualifiedName;
    }

    public String getEdgeLabel() {
        return this.edgeLabel;
    }
}

