/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.advices.applystereotype;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.types.converter.ConverterNotfoundException;
import org.eclipse.papyrus.infra.emf.types.converter.ConverterRegistry;
import org.eclipse.papyrus.uml.types.core.Activator;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ConstantValue;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.DynamicValue;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.FeatureValue;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ListValue;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.QueryExecutionValue;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.util.ApplyStereotypeAdviceSwitch;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;

public class StereotypeFeatureValueUtils {
    protected StereotypeFeatureValueUtils() {
    }

    public static Object getValue(final EObject elementToConfigure, final Stereotype stereotype, final Type type, FeatureValue featureValue) {
        Object result = new ApplyStereotypeAdviceSwitch<Object>(){

            @Override
            public Object caseConstantValue(ConstantValue object) {
                ValueSpecification valueSpecification = object.getValueInstance();
                if (valueSpecification == null) {
                    return null;
                }
                try {
                    if (type instanceof PrimitiveType) {
                        PrimitiveType pType = (PrimitiveType)type;
                        String name = pType.getName();
                        if ("Boolean".equals(name)) {
                            return ConverterRegistry.getSingleton().convert(Boolean.TYPE, valueSpecification);
                        }
                        if ("Integer".equals(name)) {
                            return ConverterRegistry.getSingleton().convert(Integer.TYPE, valueSpecification);
                        }
                        if ("Real".equals(name)) {
                            return ConverterRegistry.getSingleton().convert(Double.TYPE, valueSpecification);
                        }
                        if ("String".equals(name)) {
                            return ConverterRegistry.getSingleton().convert(String.class, valueSpecification);
                        }
                        if ("UnlimitedNatural".equals(name)) {
                            return ConverterRegistry.getSingleton().convert(Integer.TYPE, valueSpecification);
                        }
                        return ConverterRegistry.getSingleton().convert(String.class, valueSpecification);
                    }
                    if (type instanceof Enumeration) {
                        return ConverterRegistry.getSingleton().convert(Enumeration.class, valueSpecification);
                    }
                    if (type instanceof DataType) {
                        return ConverterRegistry.getSingleton().convert(String.class, valueSpecification);
                    }
                }
                catch (ConverterNotfoundException e) {
                    Activator.log.error("Impossible to convert " + String.valueOf(valueSpecification) + " to fit feature type :" + String.valueOf(type), (Throwable)e);
                }
                return super.caseConstantValue(object);
            }

            @Override
            public Object caseQueryExecutionValue(QueryExecutionValue object) {
                throw new UnsupportedOperationException("Query execution values resolution has not been implemented yet");
            }

            @Override
            public Object caseDynamicValue(DynamicValue object) {
                throw new UnsupportedOperationException("Dynamic values resolution has not been implemented yet");
            }

            @Override
            public Object caseListValue(ListValue object) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (FeatureValue value : object.getValues()) {
                    Object singleResult = StereotypeFeatureValueUtils.getValue(elementToConfigure, stereotype, type, value);
                    results.add(singleResult);
                }
                return results;
            }
        }.doSwitch(featureValue);
        return result;
    }
}

