/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.viewpoints.policy.ModelAddData;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class FullStateInvariantCreateCommandCN
extends EditElementCommand {
    private Diagram diagram = null;

    public FullStateInvariantCreateCommandCN(CreateElementRequest req, Diagram diagram) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.diagram = diagram;
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        return container;
    }

    public boolean canExecute() {
        EObject target = this.getElementToEdit();
        ModelAddData data = PolicyChecker.getFor((EObject)target).getChildAddData(this.diagram, target.eClass(), UMLPackage.eINSTANCE.getStateInvariant());
        return data.isPermitted();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        StateInvariant newElement = UMLFactory.eINSTANCE.createStateInvariant();
        EObject target = this.getElementToEdit();
        ModelAddData data = PolicyChecker.getFor((EObject)target).getChildAddData(this.diagram, target, (EObject)newElement);
        if (data.isPermitted()) {
            if (data.isPathDefined()) {
                if (!data.execute(target, (EObject)newElement)) {
                    return CommandResult.newErrorCommandResult((String)"Failed to follow the policy-specified for the insertion of the new element");
                }
            } else {
                Lifeline qualifiedTarget = (Lifeline)target;
                qualifiedTarget.getCoveredBys().add((Object)newElement);
            }
        } else {
            return CommandResult.newErrorCommandResult((String)"The active policy restricts the addition of this element");
        }
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(StateInvariant newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

