/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.clipboard.ICopierFactory;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;

public class DefaultCopyCommand
extends AbstractOverrideableCommand
implements AbstractCommand.NonDirtying {
    private final Collection<Object> objectsToPutInClipboard = new ArrayList<Object>();
    private Collection<Object> oldClipboardContent;

    public Collection<Object> getObjectsToPutInClipboard() {
        return this.objectsToPutInClipboard;
    }

    public DefaultCopyCommand(EditingDomain domain, PapyrusClipboard papyrusClipboard, Collection<EObject> pObjectsToPutInClipboard) {
        super(domain);
        boolean keepReferences = Activator.getInstance().getPreferenceStore().getBoolean("KEEP_EXTERNAL_REFERENCES");
        EcoreUtil.Copier copier = (EcoreUtil.Copier)ICopierFactory.getInstance((ResourceSet)domain.getResourceSet(), (boolean)keepReferences).get();
        copier.copyAll(pObjectsToPutInClipboard);
        copier.copyReferences();
        papyrusClipboard.addAllInternalCopyInClipboard((Map)copier);
        this.objectsToPutInClipboard.add(copier.values());
    }

    public void doExecute() {
        this.oldClipboardContent = this.domain.getClipboard();
        this.domain.setClipboard(this.objectsToPutInClipboard);
    }

    public void doUndo() {
        this.domain.setClipboard(this.oldClipboardContent);
    }

    public void doRedo() {
        this.domain.setClipboard(this.objectsToPutInClipboard);
    }

    protected boolean prepare() {
        return this.domain != null;
    }
}

