/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.symbols.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.AbstractShapeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ProviderNotificationManager;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.symbols.Activator;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Stereotype;
import org.w3c.dom.svg.SVGDocument;

public class StereotypedElementShapeProvider
extends AbstractShapeProvider {
    private static final String SHAPE_CONSTANT = "shape";
    protected static final String SHAPE_STEREOTYPE_PROPERTY = "shapeStereotype";
    protected static final String SHAPE_DECORATION_STEREOTYPE_PROPERTY = "shapeDecorationStereotype";

    public List<RenderedImage> getShapes(EObject view) {
        if (!(view instanceof View)) {
            return null;
        }
        View v = (View)view;
        if (!this.isShapeStereotypeEnable(v)) {
            return null;
        }
        return this.doGetShapes(v);
    }

    protected List<RenderedImage> doGetShapes(View view) {
        EObject element = view.getElement();
        if (element instanceof Element) {
            ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
            Iterator appliedStereotypes = ((Element)element).getAppliedStereotypes().iterator();
            while (appliedStereotypes.hasNext()) {
                try {
                    Image icon;
                    Stereotype appliedStereotype = (Stereotype)appliedStereotypes.next();
                    DecorationNode stereotypeLabel = StereotypeDisplayUtil.getInstance().getStereotypeLabel(view, appliedStereotype);
                    if (stereotypeLabel == null || !stereotypeLabel.isVisible() || (icon = ElementUtil.getStereotypeImage((Element)((Element)element), (Stereotype)appliedStereotype, (String)SHAPE_CONSTANT)) == null || icon.getLocation() == null || "".equals(icon.getLocation())) continue;
                    SVGDocument document = this.getSVGDocument(icon.getLocation());
                    if (document != null) {
                        images.add(this.renderSVGDocument((EObject)view, document));
                        continue;
                    }
                    URL url = new URL(icon.getLocation());
                    images.add(RenderedImageFactory.getInstance((URL)url));
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
            return images;
        }
        return null;
    }

    public List<RenderedImage> getShapesForDecoration(EObject view) {
        if (!(view instanceof View)) {
            return null;
        }
        View v = (View)view;
        if (!this.isShapeDecorationStereotypeEnable(v)) {
            return null;
        }
        return this.doGetShapesForDecoration(v);
    }

    protected List<RenderedImage> doGetShapesForDecoration(View view) {
        return this.doGetShapes(view);
    }

    public boolean providesShapes(EObject view) {
        if (!(view instanceof View)) {
            return false;
        }
        View v = (View)view;
        if (!this.isShapeStereotypeEnable(v)) {
            return false;
        }
        EObject element = v.getElement();
        if (element instanceof Element) {
            for (Stereotype appliedStereotype : ((Element)element).getAppliedStereotypes()) {
                Image icon;
                DecorationNode stereotypeLabel = StereotypeDisplayUtil.getInstance().getStereotypeLabel(v, appliedStereotype);
                if (stereotypeLabel == null || !stereotypeLabel.isVisible() || (icon = ElementUtil.getStereotypeImage((Element)((Element)element), (Stereotype)appliedStereotype, (String)SHAPE_CONSTANT)) == null || "".equals(icon.getLocation()) || icon.getLocation() == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isShapeStereotypeEnable(View view) {
        return NotationUtils.getBooleanValue((View)view, (String)SHAPE_STEREOTYPE_PROPERTY, (boolean)true);
    }

    private boolean isShapeDecorationStereotypeEnable(View view) {
        return NotationUtils.getBooleanValue((View)view, (String)SHAPE_DECORATION_STEREOTYPE_PROPERTY, (boolean)true);
    }

    public List<SVGDocument> getSVGDocument(EObject view) {
        if (!(view instanceof View)) {
            return null;
        }
        View v = (View)view;
        if (!this.isShapeStereotypeEnable(v)) {
            return null;
        }
        EObject element = v.getElement();
        if (element instanceof Element) {
            ArrayList<SVGDocument> images = new ArrayList<SVGDocument>();
            for (Stereotype appliedStereotype : ((Element)element).getAppliedStereotypes()) {
                SVGDocument document;
                Image icon;
                DecorationNode stereotypeLabel = StereotypeDisplayUtil.getInstance().getStereotypeLabel(v, appliedStereotype);
                if (stereotypeLabel == null || !stereotypeLabel.isVisible() || (icon = ElementUtil.getStereotypeImage((Element)((Element)element), (Stereotype)appliedStereotype, (String)SHAPE_CONSTANT)) == null || icon.getLocation() == null || "".equals(icon.getLocation()) || (document = this.getSVGDocument(icon.getLocation())) == null) continue;
                images.add(document);
            }
            return images;
        }
        return null;
    }

    public ProviderNotificationManager createProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener listener) {
        if (view == null || !(view instanceof View)) {
            return null;
        }
        StereotypedElementShapeProviderNotificationManager notificationManager = new StereotypedElementShapeProviderNotificationManager(diagramEventBroker, view, listener);
        return notificationManager;
    }

    public class StereotypedElementShapeProviderNotificationManager
    extends ProviderNotificationManager
    implements NotificationListener {
        public StereotypedElementShapeProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener listener) {
            super(diagramEventBroker, view, listener);
        }

        protected void registerListeners() {
            if (this.view == null || !(this.view instanceof View)) {
                return;
            }
            this.diagramEventBroker.addNotificationListener(this.view, (NotificationListener)this);
        }

        public void dispose() {
            if (this.view == null || !(this.view instanceof View)) {
                return;
            }
            this.diagramEventBroker.removeNotificationListener(this.view, (NotificationListener)this);
            super.dispose();
        }

        public void notifyChanged(Notification notification) {
        }
    }
}

