/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.swt.CheckWrapped;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckableWrapperList<S>
extends TransformedList<S, CheckWrapped<S>> {
    private List<CheckWrapped<S>> wrappedSource = new ArrayList<CheckWrapped<S>>();

    public CheckableWrapperList(EventList<S> source) {
        super(source);
        this.prepareElements();
        source.addListEventListener(this);
    }

    @Override
    protected boolean isWritable() {
        return false;
    }

    @Override
    public CheckWrapped<S> set(int index, CheckWrapped<S> value) {
        this.source.set(index, value.getWrapped());
        return value;
    }

    private void prepareElements() {
        int n = this.source.size();
        for (int i = 0; i < n; ++i) {
            this.wrappedSource.add(i, new CheckWrapped(this.source.get(i)));
        }
    }

    @Override
    public CheckWrapped<S> get(int index) {
        return this.wrappedSource.get(index);
    }

    @Override
    public void listChanged(ListEvent listChanges) {
        this.updates.beginEvent();
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            switch (changeType) {
                case 2: {
                    this.wrappedSource.add(changeIndex, new CheckWrapped(this.source.get(changeIndex)));
                    break;
                }
                case 1: {
                    this.wrappedSource.get(changeIndex).setWrapped(this.source.get(changeIndex));
                    break;
                }
                case 0: {
                    this.wrappedSource.remove(changeIndex);
                }
            }
            this.updates.addChange(changeType, changeIndex);
        }
        this.updates.commitEvent();
    }
}

