/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter;

import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.papyrus.infra.nattable.filter.FilterPreferences;
import org.eclipse.papyrus.infra.nattable.filter.GlazedListsImpl;

public class PapyrusThresholdMatcherEditor<E, T>
extends AbstractMatcherEditor<E> {
    public static final MatchOperation GREATER_THAN = new MatchOperation(1, false);
    public static final MatchOperation GREATER_THAN_OR_EQUAL = new MatchOperation(1, true);
    public static final MatchOperation LESS_THAN = new MatchOperation(-1, false);
    public static final MatchOperation LESS_THAN_OR_EQUAL = new MatchOperation(-1, true);
    public static final MatchOperation EQUAL = new MatchOperation(0, true);
    public static final MatchOperation NOT_EQUAL = new MatchOperation(0, false);
    private MatchOperation currentMatcher;
    private Comparator<T> comparator;
    private MatchOperation operation;
    private T threshold;
    private FunctionList.Function<E, T> function;
    private int columnIndex;
    private Object objectToMatch;

    public PapyrusThresholdMatcherEditor() {
        this(null);
    }

    public PapyrusThresholdMatcherEditor(T threshold) {
        this(threshold, null);
    }

    public PapyrusThresholdMatcherEditor(T threshold, MatchOperation operation) {
        this(threshold, operation, null);
    }

    public PapyrusThresholdMatcherEditor(T threshold, MatchOperation operation, Comparator<T> comparator) {
        this(threshold, operation, comparator, null);
    }

    public PapyrusThresholdMatcherEditor(T threshold, MatchOperation operation, Comparator<T> comparator, FunctionList.Function<E, T> function) {
        this(threshold, operation, comparator, function, -1, null);
    }

    public PapyrusThresholdMatcherEditor(T threshold, MatchOperation operation, Comparator<T> comparator, FunctionList.Function<E, T> function, int columnIndex, Object objectToMatch) {
        Object modifiedFunction;
        Comparator modifiedComparator;
        MatchOperation modifiedOperation = operation;
        if (modifiedOperation == null) {
            modifiedOperation = GREATER_THAN;
        }
        if ((modifiedComparator = comparator) == null) {
            modifiedComparator = GlazedLists.comparableComparator();
        }
        if ((modifiedFunction = function) == null) {
            modifiedFunction = GlazedListsImpl.identityFunction();
        }
        this.operation = modifiedOperation;
        this.comparator = modifiedComparator;
        this.threshold = threshold;
        this.function = modifiedFunction;
        this.columnIndex = columnIndex;
        this.objectToMatch = objectToMatch;
        this.currentMatcher = modifiedOperation.instance(modifiedComparator, threshold, modifiedFunction);
        this.fireChanged(this.currentMatcher);
    }

    public void setThreshold(T threshold) {
        this.threshold = threshold;
        this.rebuildMatcher();
    }

    public T getThreshold() {
        return this.threshold;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Object getObjectToMatch() {
        return this.objectToMatch;
    }

    public void setMatchOperation(MatchOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation cannot be null");
        }
        this.operation = operation;
        this.rebuildMatcher();
    }

    public MatchOperation getMatchOperation() {
        return this.operation;
    }

    public void setComparator(Comparator<T> comparator) {
        if (comparator == null) {
            comparator = GlazedLists.comparableComparator();
        }
        this.comparator = comparator;
        this.rebuildMatcher();
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    private void rebuildMatcher() {
        MatchOperation<E, T> newMatcher = this.operation.instance(this.comparator, this.threshold, this.function);
        boolean moreStrict = newMatcher.isMoreStrict(this.currentMatcher);
        boolean lessStrict = this.currentMatcher.isMoreStrict(newMatcher);
        if (!moreStrict && !lessStrict) {
            return;
        }
        this.currentMatcher = newMatcher;
        if (moreStrict && lessStrict) {
            this.fireChanged(this.currentMatcher);
        } else if (moreStrict) {
            this.fireConstrained(this.currentMatcher);
        } else {
            this.fireRelaxed(this.currentMatcher);
        }
    }

    private static class MatchOperation<E, T>
    implements Matcher<E> {
        protected final Comparator<T> comparator;
        protected final T threshold;
        private final int polarity;
        private final boolean inclusive;
        private final FunctionList.Function<E, T> function;

        private MatchOperation(Comparator<T> comparator, T threshold, int polarity, boolean inclusive, FunctionList.Function<E, T> function) {
            this.comparator = comparator;
            this.threshold = threshold;
            this.polarity = polarity;
            this.inclusive = inclusive;
            this.function = function;
        }

        private MatchOperation(int polarity, boolean inclusive) {
            this(null, null, polarity, inclusive, GlazedListsImpl.identityFunction());
        }

        private MatchOperation<E, T> instance(Comparator<T> comparator, T threshold, FunctionList.Function<E, T> function) {
            return new MatchOperation<E, T>(comparator, threshold, this.polarity, this.inclusive, function);
        }

        boolean isMoreStrict(MatchOperation<E, T> other) {
            if (other.polarity != this.polarity) {
                return true;
            }
            if (other.comparator != this.comparator) {
                return true;
            }
            if (other.threshold == this.threshold) {
                if (this.polarity == 0) {
                    return other.inclusive ^ this.inclusive;
                }
                return other.inclusive && !this.inclusive;
            }
            if (this.polarity == 0) {
                return true;
            }
            return !this.matchesThreshold(other.threshold);
        }

        public boolean matches(E item) {
            return this.matchesThreshold(this.function.evaluate(item));
        }

        public boolean matchesThreshold(T t) {
            if (t instanceof Collection) {
                Collection coll = (Collection)t;
                ArrayList<Integer> res = new ArrayList<Integer>();
                int nbInconsistantValue = 0;
                for (Object object : coll) {
                    int compareResult = this.comparator.compare(object, this.threshold);
                    if (compareResult == Integer.MIN_VALUE) {
                        ++nbInconsistantValue;
                    }
                    res.add(compareResult);
                }
                if (nbInconsistantValue == coll.size()) {
                    return FilterPreferences.displayInconsistentValueWithFilter(null);
                }
                if (this.inclusive) {
                    if (this.polarity == 0) {
                        return res.contains(0);
                    }
                    if (this.polarity == -1) {
                        return res.contains(this.polarity) || res.contains(0);
                    }
                    if (this.polarity == 1) {
                        return res.contains(this.polarity) || res.contains(0);
                    }
                } else {
                    if (this.polarity == 0) {
                        return res.contains(0);
                    }
                    if (this.polarity == -1) {
                        return res.contains(this.polarity);
                    }
                    if (this.polarity == 1) {
                        return res.contains(this.polarity);
                    }
                }
                throw new UnsupportedOperationException("we produced an impossible case");
            }
            int compareResult = this.comparator.compare(t, this.threshold);
            if (Integer.MIN_VALUE == compareResult) {
                return FilterPreferences.displayInconsistentValueWithFilter(null);
            }
            if (compareResult == 0) {
                return this.inclusive;
            }
            if (this.polarity == 0) {
                return !this.inclusive;
            }
            return compareResult < 0 == this.polarity < 0;
        }
    }
}

