/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.display.converter;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.papyrus.infra.services.labelprovider.service.IQualifierLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

public class ObjectNameAndPathDisplayConverter
extends DisplayConverter {
    private LabelProviderService serv;
    private static final String NAME_AND_PATH_SEPARATOR = " - ";
    private static final String MULTI_VALUE_SEPARATOR = ",";

    public ObjectNameAndPathDisplayConverter(LabelProviderService service) {
        this.serv = service;
    }

    public Object canonicalToDisplayValue(Object canonicalValue) {
        if (canonicalValue == null) {
            return null;
        }
        return this.getText(canonicalValue);
    }

    private String getText(Object object) {
        if (object == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Collection) {
            Collection coll = (Collection)object;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                String txt = this.getText(next);
                if (txt == null || txt.isEmpty()) continue;
                buffer.append(txt);
                if (!iter.hasNext()) continue;
                buffer.append(MULTI_VALUE_SEPARATOR);
                buffer.append(" ");
            }
            return buffer.toString();
        }
        ILabelProvider provider = this.serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.body.labelprovider", object);
        if (provider instanceof IQualifierLabelProvider) {
            String txt = provider.getText(object);
            if (txt != null && !txt.isEmpty()) {
                buffer.append(txt);
                String path = ((IQualifierLabelProvider)provider).getQualifierText(object);
                if (path != null && !path.isEmpty()) {
                    buffer.append(NAME_AND_PATH_SEPARATOR);
                    buffer.append(path);
                }
            }
        } else {
            buffer.append(this.serv.getLabelProvider(object).getText(object));
        }
        return buffer.toString();
    }

    public Object displayToCanonicalValue(Object displayValue) {
        throw new UnsupportedOperationException();
    }
}

