/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.strategy.ContainmentBrowseStrategy;
import org.eclipse.papyrus.infra.ui.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.ui.internal.emf.Activator;
import org.eclipse.papyrus.infra.ui.providers.ISemanticContentProviderFactory;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.strategy.StrategyBasedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.TreeBrowseStrategy;

public class ProviderHelper {
    public static ICustomizationManager getCustomizationManager() {
        return Activator.getDefault().getCustomizationManager();
    }

    public static EMFGraphicalContentProvider encapsulateProvider(ITreeContentProvider provider, ResourceSet resourceSet, String historyId) {
        ProviderBasedBrowseStrategy browseStrategy = new ProviderBasedBrowseStrategy(provider);
        ContainmentBrowseStrategy revealStrategy = new ContainmentBrowseStrategy(provider);
        StrategyBasedContentProvider strategyProvider = new StrategyBasedContentProvider((TreeBrowseStrategy)browseStrategy, (TreeBrowseStrategy)revealStrategy);
        EMFGraphicalContentProvider graphicalProvider = new EMFGraphicalContentProvider((IStructuredContentProvider)strategyProvider, resourceSet, historyId);
        return graphicalProvider;
    }

    public static EMFGraphicalContentProvider encapsulateProvider(ITreeContentProvider provider, EObject editedEObject, EStructuralFeature feature) {
        ResourceSet rs = editedEObject == null ? null : (editedEObject.eResource() == null ? null : editedEObject.eResource().getResourceSet());
        return ProviderHelper.encapsulateProvider(provider, rs, HistoryUtil.getHistoryID((EObject)editedEObject, (EStructuralFeature)feature));
    }

    public static ISemanticContentProviderFactory getContentProviderFactory(ResourceSet resourceSet) {
        List models = resourceSet instanceof ModelSet ? ILanguageService.getLanguageModels((ModelSet)((ModelSet)resourceSet)) : Collections.emptyList();
        return models.stream().map(m -> (ISemanticContentProviderFactory)m.getAdapter(ISemanticContentProviderFactory.class)).filter(Objects::nonNull).reduce(ISemanticContentProviderFactory::compose).orElse(SemanticEMFContentProvider::new);
    }

    public static ITreeContentProvider getContentProvider(ResourceSet resourceSet) {
        return ProviderHelper.getContentProviderFactory(resourceSet).createSemanticContentProvider(resourceSet);
    }

    public static List<Object> findObjectsToReveal(Collection<EObject> modelElements, ITreeContentProvider contentProvider, Object providerInput) {
        ArrayList<Object> toReveal = new ArrayList<Object>();
        ITreeContentProvider provider = contentProvider;
        HashMap allParents = new HashMap();
        for (EObject eObject : modelElements) {
            Object parent = provider.getParent((Object)eObject);
            if (parent != null) {
                if (!allParents.containsKey(parent)) {
                    allParents.put(parent, new HashSet());
                }
                ((Collection)allParents.get(parent)).add(eObject);
                continue;
            }
            Object providerElement = Arrays.stream(provider.getElements(providerInput)).filter(element -> EMFHelper.getEObject((Object)element) == modelElement).findFirst().orElse(eObject);
            toReveal.add(providerElement);
        }
        for (Map.Entry entry : allParents.entrySet()) {
            Object[] children = provider.getChildren(entry.getKey());
            Collection semanticToReveal = (Collection)entry.getValue();
            Arrays.stream(children).filter(child -> semanticToReveal.contains(EMFHelper.getEObject((Object)child))).forEach(toReveal::add);
        }
        return toReveal;
    }

    public static void selectReveal(Collection<EObject> modelElements, StructuredViewer viewer) {
        IContentProvider contentProvider = viewer.getContentProvider();
        if (contentProvider instanceof ITreeContentProvider) {
            List<Object> toReveal = ProviderHelper.findObjectsToReveal(modelElements, (ITreeContentProvider)contentProvider, viewer.getInput());
            viewer.setSelection((ISelection)new StructuredSelection(toReveal), true);
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(new ArrayList<EObject>(modelElements)), true);
        }
    }
}

