/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.databinding.TextObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.selectors.StringSelector;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StringWithClearEditor
extends AbstractValueEditor
implements KeyListener,
ModifyListener {
    protected final Text text;
    private int delay = 600;
    private boolean validateOnDelay = false;
    private Timer timer;
    private TimerTask currentValidateTask;
    private TimerTask changeColorTask;
    private static final String CLEAR_ENABLED_ICON = "/icons/clear_enabled.gif";
    private static final String CLEAR_DISABLED_ICON = "/icons/clear_disabled.gif";
    protected static final String ASTERISK = "*";
    protected static final String EMPTY = "";
    private Map<String, String> stringReplacementMap = new HashMap<String, String>();

    public StringWithClearEditor(Composite parent, int style) {
        this(parent, style, null);
    }

    public StringWithClearEditor(Composite parent, int style, String label) {
        super(parent, label);
        Composite filterComposite = new Composite((Composite)this, style);
        filterComposite.setBackground(parent.getDisplay().getSystemColor(25));
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        filterComposite.setLayout((Layout)filterLayout);
        filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.text = new Text(filterComposite, 0);
        this.text.setLayoutData((Object)new GridData(4, 1, true, false));
        this.text.setFont(parent.getFont());
        final Label clearButton = new Label(filterComposite, 0);
        clearButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        clearButton.setBackground(parent.getDisplay().getSystemColor(25));
        clearButton.setToolTipText(Messages.StringWithClearEditor_ClearFilter);
        clearButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                StringWithClearEditor.this.text.setText(StringWithClearEditor.EMPTY);
                StringWithClearEditor.this.notifyChange();
            }
        });
        ImageDescriptor imageDescriptor = Activator.getDefault().getImageDescriptor(CLEAR_DISABLED_ICON);
        clearButton.setImage(Activator.getDefault().getImage(imageDescriptor));
        clearButton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent pEvent) {
                ImageDescriptor imageDescriptor = Activator.getDefault().getImageDescriptor(StringWithClearEditor.CLEAR_ENABLED_ICON);
                clearButton.setImage(Activator.getDefault().getImage(imageDescriptor));
            }

            public void mouseExit(MouseEvent pEvent) {
                ImageDescriptor imageDescriptor = Activator.getDefault().getImageDescriptor(StringWithClearEditor.CLEAR_DISABLED_ICON);
                clearButton.setImage(Activator.getDefault().getImage(imageDescriptor));
            }
        });
        this.text.addKeyListener((KeyListener)this);
        this.text.addModifyListener((ModifyListener)this);
        this.setCommitOnFocusLost((Control)this.text);
        this.controlDecoration = new ControlDecoration((Control)this.text, 16512);
        this.controlDecoration.hide();
        this.pack();
    }

    @Override
    protected GridData getLabelLayoutData() {
        GridData result = super.getLabelLayoutData();
        if (this.text != null && (this.text.getStyle() & 2) != 0) {
            result.verticalAlignment = 1;
        }
        return result;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            if ((this.text.getStyle() & 2) == 0) {
                if (e.stateMask == 0) {
                    this.notifyChange();
                }
            } else if (e.stateMask == 262144) {
                String str = this.text.getText();
                if (str.endsWith(StringSelector.LINE_SEPARATOR)) {
                    int newLength = str.length() - StringSelector.LINE_SEPARATOR.length();
                    this.text.setText(str.substring(0, newLength));
                    this.text.setSelection(newLength);
                }
                this.notifyChange();
            }
        }
    }

    @Override
    public void setModelObservable(IObservableValue observable) {
        this.setWidgetObservable((IObservableValue)new TextObservableValue(this.text, observable, 16), true);
        super.setModelObservable(observable);
    }

    @Override
    public Object getEditableType() {
        return String.class;
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.text.setEnabled(!readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return !this.text.isEnabled();
    }

    protected void notifyChange() {
        this.text.notifyListeners(16, new Event());
        this.commit();
        this.changeColorField();
    }

    public void setToolTipText(String tooltip) {
        this.text.setToolTipText(tooltip);
        super.setLabelToolTipText(tooltip);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.text.setText((String)value);
        } else {
            this.text.setText(EMPTY);
        }
    }

    public void setValidateOnDelay(boolean validateOnDelay) {
        this.validateOnDelay = validateOnDelay;
        if (validateOnDelay) {
            this.text.addModifyListener((ModifyListener)this);
        } else {
            this.text.removeModifyListener((ModifyListener)this);
            this.cancelCurrentTask();
        }
    }

    public void setValidateOnDelay(int millis) {
        this.delay = millis;
        this.setValidateOnDelay(true);
        if (this.delay == 0) {
            this.cancelCurrentTask();
        }
    }

    private void cancelCurrentTask() {
        if (this.currentValidateTask != null) {
            this.currentValidateTask.cancel();
            this.currentValidateTask = null;
        }
    }

    public void modifyText(ModifyEvent e) {
        IStatus status;
        if (this.stringReplacementMap.size() > 0) {
            Point selection = this.text.getSelection();
            Set<Map.Entry<String, String>> entrySet = this.stringReplacementMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                if (!this.text.getText().contains(entry.getKey())) continue;
                this.text.setText(this.getValue().replace(entry.getKey(), entry.getValue()));
            }
            this.text.setSelection(selection);
        }
        if (this.validateOnDelay) {
            if (this.delay == 0) {
                this.commit();
                return;
            }
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.cancelCurrentTask();
            this.currentValidateTask = new TimerTask(){

                @Override
                public void run() {
                    StringWithClearEditor.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            StringWithClearEditor.this.commit();
                        }
                    });
                }
            };
            this.timer.schedule(this.currentValidateTask, this.delay);
        }
        if (this.targetValidator != null) {
            status = this.targetValidator.validate(this.text.getText());
            this.updateStatus(status);
        }
        if (this.modelValidator != null) {
            status = this.modelValidator.validate((Object)this.text.getText());
            this.updateStatus(status);
            if (this.binding == null) {
                this.update();
            }
        }
        if (this.modelProperty != null) {
            if (this.modelProperty.getValue() != null) {
                if (!this.isReadOnly() && !this.modelProperty.getValue().toString().equals(this.text.getText())) {
                    this.text.setBackground(EDIT);
                } else {
                    this.text.setBackground(DEFAULT);
                }
            } else if (this.text.getText().equals(EMPTY)) {
                this.text.setBackground(DEFAULT);
            } else {
                this.text.setBackground(EDIT);
            }
        }
    }

    public void dispose() {
        this.cancelCurrentTask();
        this.cancelChangeColorTask();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        super.dispose();
    }

    public Text getText() {
        return this.text;
    }

    @Override
    public void updateStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                this.controlDecoration.hide();
                break;
            }
            case 2: {
                FieldDecoration warning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                this.controlDecoration.setImage(warning.getImage());
                this.controlDecoration.showHoverText(status.getMessage());
                this.controlDecoration.setDescriptionText(status.getMessage());
                this.controlDecoration.show();
                break;
            }
            case 4: {
                FieldDecoration error = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                this.controlDecoration.setImage(error.getImage());
                this.controlDecoration.showHoverText(status.getMessage());
                this.controlDecoration.setDescriptionText(status.getMessage());
                this.controlDecoration.show();
                break;
            }
            default: {
                this.controlDecoration.hide();
            }
        }
    }

    @Override
    public void changeColorField() {
        if (this.binding != null) {
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.cancelChangeColorTask();
            this.changeColorTask = new TimerTask(){

                @Override
                public void run() {
                    if (StringWithClearEditor.this.isDisposed()) {
                        return;
                    }
                    StringWithClearEditor.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).StringWithClearEditor.this.text.setBackground(DEFAULT);
                            (this).StringWithClearEditor.this.text.update();
                        }
                    });
                }
            };
            if (this.errorBinding) {
                this.text.setBackground(ERROR);
                this.text.update();
            } else {
                IStatus status = (IStatus)this.binding.getValidationStatus().getValue();
                switch (status.getSeverity()) {
                    case 0: 
                    case 2: {
                        this.timer.schedule(this.changeColorTask, 600L);
                        this.text.setBackground(VALID);
                        this.text.update();
                        break;
                    }
                    case 4: {
                        this.text.setBackground(ERROR);
                        this.text.update();
                    }
                }
            }
        }
    }

    public void addStringToReplace(String oldValue, String newValue) {
        Assert.isNotNull((Object)oldValue);
        Assert.isNotNull((Object)newValue);
        this.stringReplacementMap.put(oldValue, newValue);
    }

    public void removeStringToReplace(String oldValue) {
        Assert.isNotNull((Object)oldValue);
        this.stringReplacementMap.remove(oldValue);
    }

    public void clearStringToReplace() {
        this.stringReplacementMap.clear();
    }

    private void cancelChangeColorTask() {
        if (this.changeColorTask != null) {
            this.changeColorTask.cancel();
            this.changeColorTask = null;
        }
    }
}

