/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.composites;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BrowseComposite
extends Composite {
    private Text textField;
    private Button browseButton;
    private String browseButtonText = "...";

    public BrowseComposite(Composite parent, int style) {
        this(parent, style, null, true);
    }

    public BrowseComposite(Composite parent, int style, String buttonName, boolean canBeChanged) {
        super(parent, 0);
        if (buttonName != null) {
            this.browseButtonText = buttonName;
        }
        this.setEnabled(canBeChanged);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        int horizontalSpacing = 4;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 0, true, false));
        this.createWidgets(style);
        this.init();
    }

    public void addModifyListener(ModifyListener modifyListener) {
        if (this.textField != null) {
            this.textField.addModifyListener(modifyListener);
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        if (this.textField != null) {
            this.textField.removeModifyListener(modifyListener);
        }
    }

    protected void createWidgets(int style) {
        this.textField = new Text((Composite)this, 4 | style);
        this.browseButton = new Button((Composite)this, 8);
    }

    private void init() {
        this.textField.setEditable(false);
        this.textField.setBackground(Display.getCurrent().getSystemColor(1));
        this.textField.setBounds(this.getBounds());
        this.textField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    BrowseComposite.this.handleBrowse();
                }
            }
        });
        this.browseButton.setText(this.browseButtonText);
        this.browseButton.setEnabled(this.isEnabled());
        GridData data = new GridData(4, 4, false, true);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BrowseComposite.this.handleBrowse();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void handleBrowse() {
    }

    public void updateTextFieldContent(String content) {
        if (this.textField != null) {
            this.textField.setText(content);
            this.textField.setFocus();
        }
    }
}

