/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.sheet;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.uml.diagram.common.part.UMLElementChooserDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ReferenceComboAndDialogCellEditor
extends ExtendedComboBoxCellEditor {
    private Composite myEditor;
    private Control myContents;
    private Button myButton;
    private FocusListener myButtonFocusListener;
    private final UMLElementChooserDialog myElementChooserDialog;
    private final TransactionalEditingDomain myEditingDomain;

    public ReferenceComboAndDialogCellEditor(Composite parent, List<?> list, ILabelProvider labelProvider, boolean sorted, UMLElementChooserDialog chooserDialog, TransactionalEditingDomain editingDomain) {
        super(parent, list, labelProvider, sorted);
        this.myEditingDomain = editingDomain;
        this.myElementChooserDialog = chooserDialog;
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.myEditor = new Composite(parent, this.getStyle());
        this.myEditor.setFont(font);
        this.myEditor.setBackground(bg);
        this.myEditor.setLayout((Layout)new DialogCellLayout());
        this.myContents = super.createControl(this.myEditor);
        this.myButton = this.createOpenDialogButton(this.myEditor);
        this.setValueValid(true);
        return this.myEditor;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        if (this.myElementChooserDialog.open() == 0) {
            URI uri = this.myElementChooserDialog.getSelectedModelElementURI();
            try {
                return this.myEditingDomain.getResourceSet().getEObject(uri, true);
            }
            catch (WrappedException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void deactivate() {
        if (this.myButton != null && !this.myButton.isDisposed()) {
            this.myButton.removeFocusListener(this.getButtonFocusListener());
        }
        super.deactivate();
    }

    protected void doSetFocus() {
        this.myButton.setFocus();
        this.myButton.addFocusListener(this.getButtonFocusListener());
    }

    private Button createOpenDialogButton(Composite parent) {
        this.myButton = new Button(parent, 1024);
        this.myButton.setText("...");
        this.myButton.setFont(parent.getFont());
        this.myButton.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    ReferenceComboAndDialogCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.myButton.addFocusListener(this.getButtonFocusListener());
        this.myButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ReferenceComboAndDialogCellEditor.this.myButton.removeFocusListener(ReferenceComboAndDialogCellEditor.this.getButtonFocusListener());
                Object newValue = ReferenceComboAndDialogCellEditor.this.openDialogBox((Control)ReferenceComboAndDialogCellEditor.this.myEditor);
                ReferenceComboAndDialogCellEditor.this.myButton.addFocusListener(ReferenceComboAndDialogCellEditor.this.getButtonFocusListener());
                if (newValue != null) {
                    boolean newValidState = ReferenceComboAndDialogCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        ReferenceComboAndDialogCellEditor.this.markDirty();
                        ReferenceComboAndDialogCellEditor.this.doSetValue(newValue);
                    } else {
                        ReferenceComboAndDialogCellEditor.this.setErrorMessage(MessageFormat.format(ReferenceComboAndDialogCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    ReferenceComboAndDialogCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        return this.myButton;
    }

    private FocusListener getButtonFocusListener() {
        if (this.myButtonFocusListener == null) {
            this.myButtonFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                }
            };
        }
        return this.myButtonFocusListener;
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = ReferenceComboAndDialogCellEditor.this.myButton.computeSize(-1, -1, force);
            if (ReferenceComboAndDialogCellEditor.this.myContents != null) {
                ReferenceComboAndDialogCellEditor.this.myContents.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            ReferenceComboAndDialogCellEditor.this.myButton.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = ReferenceComboAndDialogCellEditor.this.myContents.computeSize(-1, -1, force);
            Point buttonSize = ReferenceComboAndDialogCellEditor.this.myButton.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

