/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.BorderedBorderItemEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.PapyrusDragBorderNodeEditPartTrackerEx;
import org.eclipse.swt.graphics.Color;

public abstract class BorderNodeEditPart
extends BorderedBorderItemEditPart
implements IPapyrusEditPart {
    public BorderNodeEditPart(View view) {
        super(view);
    }

    protected NodeFigure createMainFigure() {
        return this.createNodeFigure();
    }

    public abstract IPapyrusNodeFigure getPrimaryShape();

    public boolean supportsGradient() {
        return true;
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void setBackgroundColor(Color color) {
        this.getPrimaryShape().setBackgroundColor(color);
        this.getPrimaryShape().setIsUsingGradient(false);
        this.getPrimaryShape().setGradientData(-1, -1, 0);
    }

    protected void setGradient(GradientData gradient) {
        IPapyrusNodeFigure fig = this.getPrimaryShape();
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (gradient != null) {
            fig.setIsUsingGradient(true);
            fig.setGradientData(style.getFillColor(), gradient.getGradientColor1(), gradient.getGradientStyle());
        } else {
            fig.setIsUsingGradient(false);
        }
    }

    protected void setFontColor(Color color) {
    }

    protected void setForegroundColor(Color color) {
        this.getPrimaryShape().setForegroundColor(color);
    }

    protected void refreshShadow() {
        this.getPrimaryShape().setShadow(AppearanceHelper.showShadow((EModelElement)((View)this.getModel())));
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        Object feature = event.getFeature();
        if (this.getModel() != null && this.getModel() == event.getNotifier()) {
            if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
                this.refreshLineWidth();
            } else if (NotationPackage.eINSTANCE.getLineTypeStyle_LineType().equals(feature)) {
                this.refreshLineType();
            }
        }
        if (this.resolveSemanticElement() != null) {
            this.refreshShadow();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshShadow();
        this.refreshLineType();
        this.refreshLineWidth();
        this.refreshTransparency();
    }

    protected void setLineWidth(int width) {
        if (width < 0) {
            width = 1;
        }
        this.getPrimaryShape().setLineWidth(width);
    }

    protected void setLineType(int style) {
        this.getPrimaryShape().setLineStyle(style);
    }

    public DragTracker getDragTracker(Request request) {
        return new PapyrusDragBorderNodeEditPartTrackerEx((EditPart)this);
    }

    protected abstract IFigure createNodePlate();

    protected abstract IFigure createNodeShape();

    protected abstract IFigure setupContentPane(IFigure var1);
}

