/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.RowObjectIndexHolder;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class SelectionUtils {
    public static boolean noShiftOrControl(boolean withShiftMask, boolean withControlMask) {
        return !withShiftMask && !withControlMask;
    }

    public static boolean bothShiftAndControl(boolean withShiftMask, boolean withControlMask) {
        return withShiftMask && withControlMask;
    }

    public static boolean isControlOnly(boolean withShiftMask, boolean withControlMask) {
        return !withShiftMask && withControlMask;
    }

    public static boolean isShiftOnly(boolean withShiftMask, boolean withControlMask) {
        return withShiftMask && !withControlMask;
    }

    public static boolean isConsecutive(int[] pos) {
        int i = 1;
        while (i < pos.length) {
            if (pos[i - 1] + 1 != pos[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean hasConsecutiveSelection(SelectionLayer selectionLayer) {
        if (selectionLayer != null && SelectionUtils.isConsecutive(selectionLayer.getSelectedColumnPositions())) {
            HashMap<Integer, LinkedHashSet<Integer>> positions = new HashMap<Integer, LinkedHashSet<Integer>>();
            int column = -1;
            int row = -1;
            PositionCoordinate[] positionCoordinateArray = selectionLayer.getSelectedCellPositions();
            int n = positionCoordinateArray.length;
            int n2 = 0;
            while (n2 < n) {
                PositionCoordinate coord = positionCoordinateArray[n2];
                LinkedHashSet<Integer> rows = (LinkedHashSet<Integer>)positions.get(coord.columnPosition);
                if (rows == null) {
                    rows = new LinkedHashSet<Integer>();
                    positions.put(coord.columnPosition, rows);
                }
                rows.add(coord.rowPosition);
                column = Math.max(column, coord.columnPosition);
                row = Math.max(row, coord.rowPosition);
                ++n2;
            }
            Set previous = null;
            for (Set rows : positions.values()) {
                if (previous != null && !previous.equals(rows)) {
                    return false;
                }
                previous = rows;
            }
            if (previous != null) {
                int[] rowPositions = new int[previous.size()];
                int i = 0;
                for (Integer rowPos : previous) {
                    rowPositions[i++] = rowPos;
                }
                if (SelectionUtils.isConsecutive(rowPositions)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static ILayerCell getBottomRightCellInSelection(SelectionLayer selectionLayer) {
        if (SelectionUtils.hasConsecutiveSelection(selectionLayer)) {
            int column = -1;
            int row = -1;
            PositionCoordinate[] positionCoordinateArray = selectionLayer.getSelectedCellPositions();
            int n = positionCoordinateArray.length;
            int n2 = 0;
            while (n2 < n) {
                PositionCoordinate coord = positionCoordinateArray[n2];
                column = Math.max(column, coord.columnPosition);
                row = Math.max(row, coord.rowPosition);
                ++n2;
            }
            return selectionLayer.getCellByPosition(column, row);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> getSelectedRowObjects(SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider, boolean fullySelectedRowsOnly) {
        ArrayList<RowObjectIndexHolder<T>> rows = new ArrayList<RowObjectIndexHolder<T>>();
        if (selectionLayer != null) {
            if (fullySelectedRowsOnly) {
                void var5_10;
                int[] nArray = selectionLayer.getFullySelectedRowPositions();
                int n = nArray.length;
                boolean n2 = false;
                while (var5_10 < n) {
                    int rowPosition = nArray[var5_10];
                    SelectionUtils.addToSelection(rows, rowPosition, selectionLayer, rowDataProvider);
                    ++var5_10;
                }
            } else {
                Set<Range> rowRanges = selectionLayer.getSelectedRowPositions();
                for (Range range : rowRanges) {
                    int rowPosition = range.start;
                    while (rowPosition < range.end) {
                        SelectionUtils.addToSelection(rows, rowPosition, selectionLayer, rowDataProvider);
                        ++rowPosition;
                    }
                }
            }
        }
        Collections.sort(rows);
        ArrayList rowObjects = new ArrayList();
        for (RowObjectIndexHolder rowObjectIndexHolder : rows) {
            rowObjects.add(rowObjectIndexHolder.getRow());
        }
        return rowObjects;
    }

    private static <T> void addToSelection(List<RowObjectIndexHolder<T>> rows, int rowPosition, SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider) {
        int rowIndex = selectionLayer.getRowIndexByPosition(rowPosition);
        if (rowIndex >= 0 && rowIndex < rowDataProvider.getRowCount()) {
            T rowObject = rowDataProvider.getRowObject(rowIndex);
            rows.add(new RowObjectIndexHolder<T>(rowIndex, rowObject));
        }
    }
}

