/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.xtext.nested.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;

public class NestedXTextEditorStorage
implements IStorage {
    private TextDocument textDocument;
    private String fileExtension;
    private ICustomDirectEditorConfiguration configuration;

    public NestedXTextEditorStorage(ICustomDirectEditorConfiguration configuration, TextDocument textDocument, String fileExtension) {
        this.textDocument = textDocument;
        this.fileExtension = fileExtension;
        this.configuration = configuration;
    }

    public String getTextValue() {
        EObject semanticContext = this.textDocument.getSemanticContext();
        IParser parser = this.configuration.createParser(semanticContext);
        String string = parser.getEditString((IAdaptable)new EObjectAdapter(semanticContext), 0);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public InputStream getContents() throws CoreException {
        return new ByteArrayInputStream(this.getTextValue().getBytes());
    }

    public IPath getFullPath() {
        Resource res = this.textDocument.eResource();
        if (res == null) {
            return new Path("");
        }
        URI uri = res.getURI();
        if (uri.segmentCount() > 1) {
            uri = uri.trimSegments(1);
        }
        String xmiID = "";
        if (res instanceof XMIResource) {
            xmiID = ((XMIResource)res).getID((EObject)this.textDocument);
        }
        uri = uri.appendSegment("nested");
        uri = uri.appendSegment(xmiID);
        uri = uri.appendFileExtension(this.fileExtension);
        return new Path(uri.path());
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getName() {
        return this.getFullPath().lastSegment();
    }

    public boolean isReadOnly() {
        return false;
    }
}

