/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import plugin.Activator;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.updater.DiagramUpdater;
import xpt.diagram.updater.LinkDescriptor;
import xpt.diagram.updater.NodeDescriptor;
import xpt.diagram.updater.Utils_qvto;
import xpt.editor.VisualIDRegistry;

@Singleton
public class DiagramContentInitializer {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    private MetaModel xptMetaModel;
    @Inject
    private VisualIDRegistry xptVisualIDRegistry;
    @Inject
    private DiagramUpdater xptDiagramUpdater;
    @Inject
    private Activator xptActivator;
    @Inject
    private NodeDescriptor nodeDescriptor;
    @Inject
    private LinkDescriptor linkDescriptor;

    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _diagramContentInitializerClassName = it.getDiagramContentInitializerClassName();
        _builder.append(_diagramContentInitializerClassName);
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getEditorGen().getEditor().getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence DiagramContentInitializer(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this.attributes(it);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _initDiagramContent = this.initDiagramContent(it);
        _builder.append((Object)_initDiagramContent, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Functions.Function1 _function = container -> {
            boolean _isSansDomain = container.isSansDomain();
            return !_isSansDomain;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)it.getAllContainers(), (Functions.Function1)_function);
        for (GenContainerBase container2 : _filter) {
            _builder.append("\t");
            CharSequence _createChildren = this.createChildren(container2);
            _builder.append((Object)_createChildren, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        CharSequence _createNode = this.createNode(it);
        _builder.append((Object)_createNode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _createLinks = this.createLinks(it);
        _builder.append((Object)_createLinks, "\t");
        _builder.newLineIfNotEmpty();
        boolean _notEmpty = this._common_qvto.notEmpty(Iterables.filter((Iterable)it.getAllContainers(), GenCompartment.class));
        if (_notEmpty) {
            _builder.append("\t");
            CharSequence _compartment = this.getCompartment(it);
            _builder.append((Object)_compartment, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attributes(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private java.util.Map myDomain2NotationMap = new java.util.HashMap();");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("private java.util.Collection myLinkDescriptors = new java.util.LinkedList();");
        _builder.newLine();
        return _builder;
    }

    public CharSequence initDiagramContent(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public void initDiagramContent(org.eclipse.gmf.runtime.notation.Diagram diagram) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (!");
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t");
        _builder.append(".equals(diagram.getType())) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName, "\t\t");
        _builder.append(".getInstance().logError(\"Incorrect diagram passed as a parameter: \" + diagram.getType());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (");
        CharSequence _NotInstance = this.xptMetaModel.NotInstance(it.getDomainDiagramElement(), "diagram.getElement()");
        _builder.append((Object)_NotInstance, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append(".getInstance().logError(\"Incorrect diagram element specified: \" + diagram.getElement() + \" instead of ");
        String _name = it.getDomainDiagramElement().getEcoreClass().getName();
        _builder.append(_name, "\t\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _createChildrenMethodName = this.createChildrenMethodName((GenContainerBase)it);
        _builder.append((Object)_createChildrenMethodName, "\t");
        _builder.append("(diagram);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("createLinks(diagram);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @MetaDef
    public CharSequence createChildrenMethodName(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("create");
        String _stringUniqueIdentifier = this._common.stringUniqueIdentifier((GenCommonBase)it);
        _builder.append(_stringUniqueIdentifier);
        _builder.append("_Children");
        return _builder;
    }

    public CharSequence createChildren(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private void ");
        CharSequence _createChildrenMethodName = this.createChildrenMethodName(it);
        _builder.append((Object)_createChildrenMethodName);
        _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _collectContainedLinks = this.collectContainedLinks(it);
        _builder.append((Object)_collectContainedLinks, "\t");
        _builder.newLineIfNotEmpty();
        boolean _hasSemanticChildren = this._utils_qvto.hasSemanticChildren(it);
        if (_hasSemanticChildren) {
            _builder.append("\t");
            _builder.append("java.util.Collection childNodeDescriptors = ");
            CharSequence _semanticChildrenMethodCall = this.xptDiagramUpdater.getSemanticChildrenMethodCall(it);
            _builder.append((Object)_semanticChildrenMethodCall, "\t");
            _builder.append("(view);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("for (java.util.Iterator it = childNodeDescriptors.iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("createNode(view, (");
            CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(it.getDiagram().getEditorGen().getDiagramUpdater());
            _builder.append((Object)_qualifiedClassName, "\t\t");
            _builder.append(") it.next());");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        CharSequence _createCompartmentsChildren = this.createCompartmentsChildren(it);
        _builder.append((Object)_createCompartmentsChildren, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _collectContainedLinks(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _collectContainedLinks(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("myDomain2NotationMap.put(view.getElement(), view);");
        _builder.newLine();
        _builder.append("myLinkDescriptors.addAll(");
        CharSequence _outgoingLinksMethodCall = this.xptDiagramUpdater.getOutgoingLinksMethodCall((GenCommonBase)it);
        _builder.append((Object)_outgoingLinksMethodCall);
        _builder.append("(view));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _createCompartmentsChildren(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _createCompartmentsChildren(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        EList _compartments = it.getCompartments();
        for (GenCompartment comp : _compartments) {
            CharSequence _callCreateCompartmentChildren = this.callCreateCompartmentChildren(comp);
            _builder.append((Object)_callCreateCompartmentChildren);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence callCreateCompartmentChildren(GenCompartment it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _createChildrenMethodName = this.createChildrenMethodName((GenContainerBase)it);
        _builder.append((Object)_createChildrenMethodName);
        _builder.append("(getCompartment(view, ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence createNode(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private void createNode(org.eclipse.gmf.runtime.notation.View parentView, ");
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(it.getEditorGen().getDiagramUpdater());
        _builder.append((Object)_qualifiedClassName);
        _builder.append(" nodeDescriptor) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("final String nodeType = ");
        CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall((GenCommonBase)it, "nodeDescriptor.getVisualID()");
        _builder.append((Object)_typeMethodCall, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Node node = org.eclipse.gmf.runtime.diagram.core.services.ViewService.createNode(parentView, nodeDescriptor.getModelElement(), nodeType, ");
        CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getEditorGen());
        _builder.append((Object)_preferenceHintAccess, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("switch (nodeDescriptor.getVisualID()) {");
        _builder.newLine();
        Functions.Function1 _function = node -> {
            boolean _isSansDomain = node.isSansDomain();
            return !_isSansDomain;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)it.getAllNodes(), (Functions.Function1)_function);
        for (GenNode n : _filter) {
            _builder.append("\t\t");
            _builder.append("case ");
            CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)n);
            _builder.append((Object)_visualID, "\t\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            CharSequence _createChildrenMethodName = this.createChildrenMethodName((GenContainerBase)n);
            _builder.append((Object)_createChildrenMethodName, "\t\t\t");
            _builder.append("(node);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("return;");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createLinks(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private void createLinks(org.eclipse.gmf.runtime.notation.Diagram diagram) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (boolean continueLinkCreation = true; continueLinkCreation;) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("continueLinkCreation = false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("java.util.Collection additionalDescriptors = new java.util.LinkedList();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (java.util.Iterator it = myLinkDescriptors.iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(it.getEditorGen().getDiagramUpdater());
        _builder.append((Object)_qualifiedClassName, "\t\t\t");
        _builder.append(" nextLinkDescriptor = (");
        CharSequence _qualifiedClassName_1 = this.linkDescriptor.qualifiedClassName(it.getEditorGen().getDiagramUpdater());
        _builder.append((Object)_qualifiedClassName_1, "\t\t\t");
        _builder.append(") it.next();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("if (!myDomain2NotationMap.containsKey(nextLinkDescriptor.getSource()) || !myDomain2NotationMap.containsKey(nextLinkDescriptor.getDestination())) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("final String linkType = ");
        CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall((GenCommonBase)it, "nextLinkDescriptor.getVisualID()");
        _builder.append((Object)_typeMethodCall, "\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Edge edge = org.eclipse.gmf.runtime.diagram.core.services.ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), diagram, linkType, org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.APPEND, true, ");
        CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getEditorGen());
        _builder.append((Object)_preferenceHintAccess, "\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("if (edge != null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("edge.setSource((org.eclipse.gmf.runtime.notation.View) myDomain2NotationMap.get(nextLinkDescriptor.getSource()));");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("edge.setTarget((org.eclipse.gmf.runtime.notation.View) myDomain2NotationMap.get(nextLinkDescriptor.getDestination()));");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("it.remove();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if (nextLinkDescriptor.getModelElement() != null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("myDomain2NotationMap.put(nextLinkDescriptor.getModelElement(), edge);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("continueLinkCreation = true;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("switch (nextLinkDescriptor.getVisualID()) {");
        _builder.newLine();
        EList _links = it.getLinks();
        for (GenLink link : _links) {
            boolean _tripleNotEquals;
            GenClass _metaClass = this._utils_qvto.getMetaClass((EObject)link);
            boolean bl = _tripleNotEquals = _metaClass != null;
            if (!_tripleNotEquals) continue;
            _builder.append("\t\t\t\t\t");
            _builder.append("case ");
            CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)link);
            _builder.append((Object)_visualID, "\t\t\t\t\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t");
            _builder.append("additionalDescriptors.addAll(");
            CharSequence _outgoingLinksMethodCall = this.xptDiagramUpdater.getOutgoingLinksMethodCall((GenCommonBase)link);
            _builder.append((Object)_outgoingLinksMethodCall, "\t\t\t\t\t");
            _builder.append("(edge));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t");
            _builder.append("break;");
            _builder.newLine();
        }
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("myLinkDescriptors.addAll(additionalDescriptors);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getCompartment(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private org.eclipse.gmf.runtime.notation.Node getCompartment(org.eclipse.gmf.runtime.notation.View node, String visualID) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("String type = ");
        CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall((GenCommonBase)it, "visualID");
        _builder.append((Object)_typeMethodCall, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("for (java.util.Iterator it = node.getChildren().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View nextView = (org.eclipse.gmf.runtime.notation.View) it.next();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (nextView instanceof org.eclipse.gmf.runtime.notation.Node && type.equals(nextView.getType())) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return (org.eclipse.gmf.runtime.notation.Node) nextView;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence collectContainedLinks(GenContainerBase it) {
        if (it instanceof GenNode) {
            return this._collectContainedLinks((GenNode)it);
        }
        if (it != null) {
            return this._collectContainedLinks(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence createCompartmentsChildren(GenContainerBase it) {
        if (it instanceof GenNode) {
            return this._createCompartmentsChildren((GenNode)it);
        }
        if (it != null) {
            return this._createCompartmentsChildren(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

