/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.navigator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.editor.Editor;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class NavigatorActionProvider {
  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  @Extension
  private Common _common;

  @Inject
  private Activator xptActivator;

  @Inject
  private Externalizer xptExternalizer;

  @Inject
  private VisualIDRegistry xptVisualIDRegistry;

  @Inject
  private getEditorInput xptGetEditorInput;

  @Inject
  private NavigatorItem xptNavigatorItem;

  @Inject
  private Editor xptEditor;

  public CharSequence className(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _actionProviderClassName = it.getActionProviderClassName();
    _builder.append(_actionProviderClassName);
    return _builder;
  }

  public CharSequence packageName(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence NavigatorActionProvider(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("  extends org.eclipse.ui.navigator.CommonActionProvider {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _makeActions = this.makeActions(it);
    _builder.append(_makeActions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _fillActionBars = this.fillActionBars(it);
    _builder.append(_fillActionBars, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _fillContextMenu = this.fillContextMenu(it);
    _builder.append(_fillContextMenu, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _OpenDiagramAction = this.OpenDiagramAction(it);
    _builder.append(_OpenDiagramAction, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence attributes(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private boolean myContribute;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private OpenDiagramAction myOpenDiagramAction;");
    _builder.newLine();
    return _builder;
  }

  public CharSequence constructor(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void init(org.eclipse.ui.navigator.ICommonActionExtensionSite aSite) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.init(aSite);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (aSite.getViewSite() instanceof org.eclipse.ui.navigator.ICommonViewerWorkbenchSite) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myContribute = true;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("makeActions((org.eclipse.ui.navigator.ICommonViewerWorkbenchSite) aSite.getViewSite());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myContribute = false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence makeActions(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private void makeActions(org.eclipse.ui.navigator.ICommonViewerWorkbenchSite viewerSite) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myOpenDiagramAction = new OpenDiagramAction(viewerSite);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence fillActionBars(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void fillActionBars(org.eclipse.ui.IActionBars actionBars) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (!myContribute) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.jface.viewers.IStructuredSelection selection = (org.eclipse.jface.viewers.IStructuredSelection) getContext().getSelection();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myOpenDiagramAction.selectionChanged(selection);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (myOpenDiagramAction.isEnabled()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("actionBars.setGlobalActionHandler(org.eclipse.ui.navigator.ICommonActionConstants.OPEN, myOpenDiagramAction);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence fillContextMenu(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void fillContextMenu(org.eclipse.jface.action.IMenuManager menu) {");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence OpenDiagramAction(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static class OpenDiagramAction extends org.eclipse.jface.action.Action {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _ODA_attributes = this.ODA_attributes(it);
    _builder.append(_ODA_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _ODA_constructor = this.ODA_constructor(it);
    _builder.append(_ODA_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _ODA_selectionChanged = this.ODA_selectionChanged(it);
    _builder.append(_ODA_selectionChanged, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _ODA_run = this.ODA_run(it);
    _builder.append(_ODA_run, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _ODA_getEditorInput = this.ODA_getEditorInput(it);
    _builder.append(_ODA_getEditorInput, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence ODA_attributes(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.notation.Diagram myDiagram;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.ui.navigator.ICommonViewerWorkbenchSite myViewerSite;");
    _builder.newLine();
    return _builder;
  }

  public CharSequence ODA_constructor(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public OpenDiagramAction(org.eclipse.ui.navigator.ICommonViewerWorkbenchSite viewerSite) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForOpenDiagramActionName());
    _builder.append(_accessorCall, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("myViewerSite = viewerSite;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence ODA_selectionChanged(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public final void selectionChanged(org.eclipse.jface.viewers.IStructuredSelection selection) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myDiagram = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (selection.size() == 1) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Object selectedElement = selection.getFirstElement();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (selectedElement instanceof ");
    CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("selectedElement = ((");
    CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t\t\t");
    _builder.append(") selectedElement).getView();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else if (selectedElement instanceof org.eclipse.core.runtime.IAdaptable) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("selectedElement = ((org.eclipse.core.runtime.IAdaptable) selectedElement).getAdapter(org.eclipse.gmf.runtime.notation.View.class);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (selectedElement instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = (org.eclipse.gmf.runtime.notation.Diagram) selectedElement;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (");
    CharSequence _modelID = VisualIDRegistry.modelID(it.getEditorGen().getDiagram());
    _builder.append(_modelID, "\t\t\t");
    _builder.append(".equals(");
    CharSequence _modelIDMethodCall = this.xptVisualIDRegistry.getModelIDMethodCall(it.getEditorGen().getDiagram());
    _builder.append(_modelIDMethodCall, "\t\t\t");
    _builder.append("(diagram))) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("myDiagram = diagram;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("setEnabled(myDiagram != null);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence ODA_run(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (myDiagram == null || myDiagram.eResource() == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IEditorInput editorInput = getEditorInput(myDiagram);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IWorkbenchPage page = myViewerSite.getPage();");
    _builder.newLine();
    _builder.append(" \t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("page.openEditor(editorInput, ");
    CharSequence _qualifiedClassName = this.xptEditor.qualifiedClassName(it.getEditorGen().getEditor());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".ID);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} catch (org.eclipse.ui.PartInitException e) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(".getInstance().logError(\"Exception while openning diagram\", e);  ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence ODA_getEditorInput(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _editorInput = this.xptGetEditorInput.getEditorInput(it.getEditorGen());
    _builder.append(_editorInput);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public CharSequence i18nValues(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForOpenDiagramActionName(), "Open Diagram");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public CharSequence i18nAccessors(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForOpenDiagramActionName());
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public String i18nKeyForOpenDiagramActionName() {
    return "NavigatorActionProvider.OpenDiagramActionName";
  }
}
