/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.editpolicies.LinkUtils_qvto;
import xpt.diagram.updater.Utils_qvto;
import xpt.expressions.getExpression;

@Singleton
public class VisualIDRegistry {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    @Extension
    private LinkUtils_qvto _linkUtils_qvto;
    @Inject
    @Extension
    private MetaModel _metaModel;
    @Inject
    private CodeStyle xptCodeStyle;
    @Inject
    private MetaModel xptMetaModel;
    @Inject
    private getExpression xptGetExpression;

    @MetaDef
    public CharSequence getVisualIdMethodName(GenDiagram xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("getVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence getModelIDMethodName(GenDiagram xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("getModelID");
        return _builder;
    }

    @MetaDef
    public CharSequence getVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
        _builder.append((Object)_visualIdMethodName);
        return _builder;
    }

    @MetaDef
    public CharSequence getModelIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
        _builder.append((Object)_modelIDMethodName);
        return _builder;
    }

    @MetaDef
    public static CharSequence visualID(GenCommonBase xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        String _editPartQualifiedClassName = xptSelf.getEditPartQualifiedClassName();
        _builder.append(_editPartQualifiedClassName);
        _builder.append(".VISUAL_ID");
        return _builder;
    }

    @MetaDef
    public static CharSequence modelID(GenDiagram xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        String _editPartQualifiedClassName = xptSelf.getEditPartQualifiedClassName();
        _builder.append(_editPartQualifiedClassName);
        _builder.append(".MODEL_ID");
        return _builder;
    }

    @MetaDef
    public CharSequence typeMethodCall(GenCommonBase xptSelf, CharSequence visualIdVar) {
        StringConcatenation _builder = new StringConcatenation();
        String _visualIDRegistryQualifiedClassName = xptSelf.getDiagram().getVisualIDRegistryQualifiedClassName();
        _builder.append(_visualIDRegistryQualifiedClassName);
        _builder.append(".");
        CharSequence _typeMethodName = this.getTypeMethodName(xptSelf.getDiagram());
        _builder.append((Object)_typeMethodName);
        _builder.append("(");
        _builder.append((Object)visualIdVar);
        _builder.append(")");
        return _builder;
    }

    @MetaDef
    public CharSequence typeMethodCall(GenCommonBase xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _typeMethodCall = this.typeMethodCall(xptSelf, VisualIDRegistry.visualID(xptSelf).toString());
        _builder.append((Object)_typeMethodCall);
        return _builder;
    }

    @MetaDef
    public CharSequence getTypeMethodName(GenDiagram xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("getType");
        return _builder;
    }

    @MetaDef
    public CharSequence runtimeTypedInstanceName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("TYPED_INSTANCE");
        return _builder;
    }

    @MetaDef
    public CharSequence runtimeTypedInstanceCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _runtimeTypedInstanceName = this.runtimeTypedInstanceName(it);
        _builder.append((Object)_runtimeTypedInstanceName);
        return _builder;
    }

    @MetaDef
    public CharSequence getDiagramVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("getDiagramVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence getDiagramVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _diagramVisualIDMethodName = this.getDiagramVisualIDMethodName(it);
        _builder.append((Object)_diagramVisualIDMethodName);
        return _builder;
    }

    @MetaDef
    public CharSequence getNodeVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("getNodeVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence getNodeVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
        _builder.append((Object)_nodeVisualIDMethodName);
        return _builder;
    }

    @MetaDef
    public CharSequence canCreateNodeMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("canCreateNode");
        return _builder;
    }

    @MetaDef
    public CharSequence canCreateNodeMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _canCreateNodeMethodName = this.canCreateNodeMethodName(it);
        _builder.append((Object)_canCreateNodeMethodName);
        return _builder;
    }

    @MetaDef
    public CharSequence getLinkWithClassVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _linkWithClassVisualIDMethodName = this.getLinkWithClassVisualIDMethodName(it);
        _builder.append((Object)_linkWithClassVisualIDMethodName);
        return _builder;
    }

    @MetaDef
    public CharSequence getLinkWithClassVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("getLinkWithClassVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence domainElementConstraintMethodName(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("is");
        String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
        _builder.append(_stringUniqueIdentifier);
        return _builder;
    }

    @MetaDef
    public CharSequence checkNodeVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("checkNodeVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence checkNodeVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
        _builder.append((Object)_checkNodeVisualIDMethodName);
        return _builder;
    }

    @MetaDef
    public CharSequence isCompartmentVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isCompartmentVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence isCompartmentVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
        _builder.append((Object)_isCompartmentVisualIDMethodName);
        return _builder;
    }

    @MetaDef
    public CharSequence isSemanticLeafVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isSemanticLeafVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence isSemanticLeafVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
        _builder.append((Object)_isSemanticLeafVisualIDMethodName);
        return _builder;
    }

    protected Iterable<GenCommonBase> _getEssentialVisualChildren(GenCommonBase it) {
        return CollectionLiterals.newLinkedList();
    }

    protected Iterable<GenCommonBase> _getEssentialVisualChildren(GenLink it) {
        return Iterables.filter((Iterable)it.getLabels(), GenCommonBase.class);
    }

    protected Iterable<GenCommonBase> _getEssentialVisualChildren(GenContainerBase it) {
        return Iterables.filter((Iterable)it.getContainedNodes(), GenCommonBase.class);
    }

    protected Iterable<GenCommonBase> _getEssentialVisualChildren(GenNode it) {
        LinkedList result = CollectionLiterals.newLinkedList();
        result.addAll(it.getLabels());
        result.addAll(it.getCompartments());
        result.addAll(it.getContainedNodes());
        return result;
    }

    public Iterable<GenNode> getContainedSemanticNodes(GenContainerBase container) {
        Functions.Function1 _function = node -> {
            TypeModelFacet _modelFacet = node.getModelFacet();
            return _modelFacet != null;
        };
        return IterableExtensions.filter((Iterable)container.getContainedNodes(), (Functions.Function1)_function);
    }

    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _visualIDRegistryClassName = it.getVisualIDRegistryClassName();
        _builder.append(_visualIDRegistryClassName);
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getEditorGen().getEditor().getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence VisualIDRegistry(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment("This registry is used to determine which type of visual object should be\ncreated for the corresponding Diagram, Node, ChildNode or Link represented\nby a domain model object.");
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this.attributes(it);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _viewVisualID = this.getViewVisualID(it);
        _builder.append((Object)_viewVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _modelID = this.getModelID(it);
        _builder.append((Object)_modelID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _visualID = this.getVisualID(it);
        _builder.append((Object)_visualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _type = this.getType(it);
        _builder.append((Object)_type, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _diagramVisualID = this.getDiagramVisualID(it);
        _builder.append((Object)_diagramVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _nodeVisualID = this.getNodeVisualID(it);
        _builder.append((Object)_nodeVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _canCreateNode = this.canCreateNode(it);
        _builder.append((Object)_canCreateNode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _linkWithClassVisualID = this.getLinkWithClassVisualID(it);
        _builder.append((Object)_linkWithClassVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _isDiagram = this.isDiagram(it);
        _builder.append((Object)_isDiagram, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _constraintMethods = this.constraintMethods(it);
        _builder.append((Object)_constraintMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _checkNodeVisualID = this.checkNodeVisualID(it);
        _builder.append((Object)_checkNodeVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _isCompartmentVisualID = this.isCompartmentVisualID(it);
        _builder.append((Object)_isCompartmentVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        String _isSemanticLeafVisualID = this.isSemanticLeafVisualID(it);
        _builder.append(_isSemanticLeafVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _runtimeTypedInstance = this.runtimeTypedInstance(it);
        _builder.append((Object)_runtimeTypedInstance, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attributes(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Uncomment for debug purpose ?");
        _builder.newLine();
        _builder.append("// /**");
        _builder.newLine();
        _builder.append("// * @generated");
        _builder.newLine();
        _builder.append("// */");
        _builder.newLine();
        _builder.append("// private static final String DEBUG_KEY = \"");
        String _iD = it.getEditorGen().getPlugin().getID();
        _builder.append(_iD);
        _builder.append("/debug/visualID\"; ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getViewVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static String ");
        CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
        _builder.append((Object)_visualIdMethodName);
        _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (view instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (");
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t\t");
        _builder.append(".equals(view.getType())) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("return ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID, "\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _unrecognizedVID = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
        _builder.append((Object)_visualIDMethodCall, "\t");
        _builder.append("(view.getType());");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getModelID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static String ");
        CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
        _builder.append((Object)_modelIDMethodName);
        _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View diagram = view.getDiagram();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("while (view != diagram) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.ecore.EAnnotation annotation = view.getEAnnotation(\"Shortcut\"); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if (annotation != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return annotation.getDetails().get(\"modelID\"); ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("view = (org.eclipse.gmf.runtime.notation.View) view.eContainer();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return diagram != null ? diagram.getType() : null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static String ");
        CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
        _builder.append((Object)_visualIdMethodName);
        _builder.append("(String type) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return type;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getType(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static String ");
        CharSequence _typeMethodName = this.getTypeMethodName(it);
        _builder.append((Object)_typeMethodName);
        _builder.append("(String visualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return visualID;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getDiagramVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static String ");
        CharSequence _diagramVisualIDMethodName = this.getDiagramVisualIDMethodName(it);
        _builder.append((Object)_diagramVisualIDMethodName);
        _builder.append("(org.eclipse.emf.ecore.EObject domainElement) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (domainElement == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _unrecognizedVID = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence returnVisualID(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        CharSequence _checkSemanticElement = this.checkSemanticElement(it);
        _builder.append((Object)_checkSemanticElement);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _visualID = VisualIDRegistry.visualID(it);
        _builder.append((Object)_visualID, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _checkSemanticElement(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("checkSemanticElement not supported for: " + it);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _checkSemanticElement(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _checkDomainElementMetaclass = this.checkDomainElementMetaclass(it.getDomainDiagramElement());
        _builder.append((Object)_checkDomainElementMetaclass);
        _builder.append(" && isDiagram(");
        CharSequence _CastEObject = this.xptMetaModel.CastEObject(it.getDomainDiagramElement(), "domainElement");
        _builder.append((Object)_CastEObject);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _checkSemanticElement(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _checkDomainElementMetaclass = this.checkDomainElementMetaclass(it.getModelFacet().getMetaClass());
        _builder.append((Object)_checkDomainElementMetaclass);
        CharSequence _checkDomainElementConstraints = this.checkDomainElementConstraints(it.getModelFacet(), (GenCommonBase)it);
        _builder.append((Object)_checkDomainElementConstraints);
        return _builder;
    }

    protected CharSequence _checkSemanticElement(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _checkSemanticElement = this.checkSemanticElement(it.getModelFacet(), it);
        _builder.append((Object)_checkSemanticElement);
        return _builder;
    }

    public CharSequence checkDomainElementMetaclass(GenClass it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _MetaClass = this.xptMetaModel.MetaClass((GenClassifier)it);
        _builder.append((Object)_MetaClass);
        _builder.append(".isSuperTypeOf(domainElement.eClass())");
        return _builder;
    }

    public CharSequence checkDomainElementConstraints(TypeModelFacet it, GenCommonBase commonBase) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenConstraint _modelElementSelector = it.getModelElementSelector();
        boolean bl = _tripleNotEquals = _modelElementSelector != null;
        if (_tripleNotEquals) {
            if (commonBase instanceof GenLink || !(it.getModelElementSelector().getProvider() instanceof GenJavaExpressionProvider)) {
                _builder.append("&& ");
                CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(commonBase);
                _builder.append((Object)_domainElementConstraintMethodName);
                _builder.append("(");
                CharSequence _CastEObject = this._metaModel.CastEObject(it.getMetaClass(), "domainElement");
                _builder.append((Object)_CastEObject);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("&& ");
                CharSequence _domainElementConstraintMethodName_1 = this.domainElementConstraintMethodName(commonBase);
                _builder.append((Object)_domainElementConstraintMethodName_1);
                _builder.append("(containerView, ");
                CharSequence _CastEObject_1 = this._metaModel.CastEObject(it.getMetaClass(), "domainElement");
                _builder.append((Object)_CastEObject_1);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence _checkSemanticElement(LinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("checkSemanticElement is supported only for TypeLinkModelFacet: " + it);
        return _builder;
    }

    protected CharSequence _checkSemanticElement(TypeLinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _checkDomainElementMetaclass = this.checkDomainElementMetaclass(it.getMetaClass());
        _builder.append((Object)_checkDomainElementMetaclass);
        CharSequence _checkDomainElementConstraints = this.checkDomainElementConstraints((TypeModelFacet)it, (GenCommonBase)genLink);
        _builder.append((Object)_checkDomainElementConstraints);
        return _builder;
    }

    public CharSequence getNodeVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static String ");
        CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
        _builder.append((Object)_nodeVisualIDMethodName);
        _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (domainElement == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _unrecognizedVID = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("String containerModelID = ");
        CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
        _builder.append((Object)_modelIDMethodCall, "\t");
        _builder.append("(containerView);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (!");
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t");
        _builder.append(".equals(containerModelID)");
        EList _shortcutsProvidedFor = it.getShortcutsProvidedFor();
        for (String spf : _shortcutsProvidedFor) {
            CharSequence _checkContainerModelID = this.checkContainerModelID(spf);
            _builder.append((Object)_checkContainerModelID, "\t");
        }
        _builder.append(") { ");
        CharSequence _nonNLS_All = this._common.nonNLS_All((Iterable<?>)it.getShortcutsProvidedFor());
        _builder.append((Object)_nonNLS_All, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _unrecognizedVID_1 = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("String containerVisualID;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (");
        CharSequence _modelID_1 = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID_1, "\t");
        _builder.append(".equals(containerModelID)) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("containerVisualID = ");
        CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
        _builder.append((Object)_visualIDMethodCall, "\t\t");
        _builder.append("(containerView);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (containerView instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("containerVisualID = ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID, "\t\t\t");
        _builder.append(";\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _unrecognizedVID_2 = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID_2, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (containerVisualID != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch (containerVisualID) {");
        _builder.newLine();
        EList _allContainers = it.getAllContainers();
        for (GenContainerBase container : _allContainers) {
            _builder.append("\t\t\t");
            CharSequence _caseDomainContainerVisualID = this.caseDomainContainerVisualID(container);
            _builder.append((Object)_caseDomainContainerVisualID, "\t\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _unrecognizedVID_3 = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence caseDomainContainerVisualID(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _notEmpty = this._common_qvto.notEmpty(this.getContainedSemanticNodes(it));
        if (_notEmpty) {
            CharSequence _caseVisualID = this.caseVisualID((GenCommonBase)it);
            _builder.append((Object)_caseVisualID);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Iterable<GenNode> _containedSemanticNodes = this.getContainedSemanticNodes(it);
            for (GenNode node : _containedSemanticNodes) {
                CharSequence _returnVisualID = this.returnVisualID((GenCommonBase)node);
                _builder.append((Object)_returnVisualID, "\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence canCreateNode(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static boolean ");
        CharSequence _canCreateNodeMethodName = this.canCreateNodeMethodName(it);
        _builder.append((Object)_canCreateNodeMethodName);
        _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, String nodeVisualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("String containerModelID = ");
        CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
        _builder.append((Object)_modelIDMethodCall, "\t");
        _builder.append("(containerView);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (!");
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t");
        _builder.append(".equals(containerModelID)");
        EList _shortcutsProvidedFor = it.getShortcutsProvidedFor();
        for (String spf : _shortcutsProvidedFor) {
            CharSequence _checkContainerModelID = this.checkContainerModelID(spf);
            _builder.append((Object)_checkContainerModelID, "\t");
        }
        _builder.append(") { ");
        CharSequence _nonNLS_All = this._common.nonNLS_All((Iterable<?>)it.getShortcutsProvidedFor());
        _builder.append((Object)_nonNLS_All, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("String containerVisualID;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (");
        CharSequence _modelID_1 = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID_1, "\t");
        _builder.append(".equals(containerModelID)) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("containerVisualID = ");
        CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
        _builder.append((Object)_visualIDMethodCall, "\t\t");
        _builder.append("(containerView);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (containerView instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("containerVisualID = ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID, "\t\t\t");
        _builder.append(";\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (containerVisualID != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch (containerVisualID) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        Functions.Function1 _function = e -> this._common_qvto.notEmpty(this.getEssentialVisualChildren((GenCommonBase)e));
        Iterable _filter = IterableExtensions.filter((Iterable)it.getAllContainers(), (Functions.Function1)_function);
        for (GenContainerBase container : _filter) {
            CharSequence _checkEssentialChildren = this.checkEssentialChildren((GenCommonBase)container);
            _builder.append((Object)_checkEssentialChildren, "\t\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        Functions.Function1 _function_1 = l -> this._common_qvto.notEmpty(this.getEssentialVisualChildren((GenCommonBase)l));
        Iterable _filter_1 = IterableExtensions.filter((Iterable)it.getLinks(), (Functions.Function1)_function_1);
        for (GenLink link : _filter_1) {
            CharSequence _checkEssentialChildren_1 = this.checkEssentialChildren((GenCommonBase)link);
            _builder.append((Object)_checkEssentialChildren_1, "\t\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence checkContainerModelID(String someModelId) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        _builder.append("&& !\"");
        _builder.append(someModelId, " ");
        _builder.append("\".equals(containerModelID)");
        return _builder;
    }

    public CharSequence checkEssentialChildren(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _caseVisualID = this.caseVisualID(it);
        _builder.append((Object)_caseVisualID);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Iterable<GenCommonBase> _essentialVisualChildren = this.getEssentialVisualChildren(it);
        for (GenCommonBase child : _essentialVisualChildren) {
            CharSequence _checkEssentialChild = this.checkEssentialChild(child);
            _builder.append((Object)_checkEssentialChild, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("break;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence checkEssentialChild(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        CharSequence _visualID = VisualIDRegistry.visualID(it);
        _builder.append((Object)_visualID);
        _builder.append(".equals(nodeVisualID)) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getLinkWithClassVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static String ");
        CharSequence _linkWithClassVisualIDMethodName = this.getLinkWithClassVisualIDMethodName(it);
        _builder.append((Object)_linkWithClassVisualIDMethodName);
        _builder.append("(org.eclipse.emf.ecore.EObject domainElement) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (domainElement == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _unrecognizedVID = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function = l -> this._linkUtils_qvto.isTypeLink((GenLink)l);
        Iterable _filter = IterableExtensions.filter((Iterable)it.getLinks(), (Functions.Function1)_function);
        for (GenLink typeLink : _filter) {
            CharSequence _returnVisualID = this.returnVisualID((GenCommonBase)typeLink);
            _builder.append((Object)_returnVisualID, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _unrecognizedVID_1 = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isDiagram(GenDiagram it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        boolean bl = _tripleNotEquals = _domainDiagramElement != null;
        if (_tripleNotEquals) {
            _builder.append("// Uncomment for debug purpose ?");
            _builder.newLine();
            _builder.append("// /**");
            _builder.newLine();
            _builder.append("// * User can change implementation of this method to handle some specific");
            _builder.newLine();
            _builder.append("// * situations not covered by default logic.");
            _builder.newLine();
            _builder.append("// *");
            _builder.newLine();
            _builder.append("// * @generated");
            _builder.newLine();
            _builder.append("// */");
            _builder.newLine();
            _builder.append("// private static boolean isDiagram(Package element) {");
            _builder.newLine();
            _builder.append("// return true;");
            _builder.newLine();
            _builder.append("// }");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence constraintMethods(GenDiagram it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenExpressionProviderContainer _expressionProviders = it.getEditorGen().getExpressionProviders();
        boolean bl = _tripleNotEquals = _expressionProviders != null;
        if (_tripleNotEquals) {
            Functions.Function1 _function = n -> {
                boolean _isSansDomain = n.isSansDomain();
                return !_isSansDomain;
            };
            Functions.Function1 _function_1 = n -> {
                GenConstraint _modelElementSelector = n.getModelFacet().getModelElementSelector();
                return _modelElementSelector != null;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)it.getTopLevelNodes(), (Functions.Function1)_function), (Functions.Function1)_function_1);
            for (GenTopLevelNode topNode : _filter) {
                CharSequence _constraintMethod = this.constraintMethod((GenNode)topNode);
                _builder.append((Object)_constraintMethod);
            }
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_2 = n -> {
                boolean _isSansDomain = n.isSansDomain();
                return !_isSansDomain;
            };
            Functions.Function1 _function_3 = n -> {
                GenConstraint _modelElementSelector = n.getModelFacet().getModelElementSelector();
                return _modelElementSelector != null;
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)it.getChildNodes(), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
            for (GenChildNode childNode : _filter_1) {
                CharSequence _constraintMethod_1 = this.constraintMethod((GenNode)childNode);
                _builder.append((Object)_constraintMethod_1);
            }
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_4 = n -> {
                boolean _isSansDomain = n.isSansDomain();
                return !_isSansDomain;
            };
            Iterable _filter_2 = IterableExtensions.filter((Iterable)it.getLinks(), (Functions.Function1)_function_4);
            for (GenLink link : _filter_2) {
                CharSequence _constraintMethod_2 = this.constraintMethod(link.getModelFacet(), link);
                _builder.append((Object)_constraintMethod_2);
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence constraintMethod(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _domainElementConstraintMethod = this.domainElementConstraintMethod(it.getModelFacet().getModelElementSelector().getProvider(), (GenCommonBase)it, (ValueExpression)it.getModelFacet().getModelElementSelector(), it.getModelFacet().getMetaClass());
        _builder.append((Object)_domainElementConstraintMethod);
        return _builder;
    }

    protected CharSequence _constraintMethod(LinkModelFacet it, GenLink l) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _constraintMethod(TypeLinkModelFacet it, GenLink l) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenConstraint _modelElementSelector = it.getModelElementSelector();
        boolean bl = _tripleNotEquals = _modelElementSelector != null;
        if (_tripleNotEquals) {
            CharSequence _domainElementConstraintMethod = this.domainElementConstraintMethod(it.getModelElementSelector().getProvider(), (GenCommonBase)l, (ValueExpression)it.getModelElementSelector(), it.getMetaClass());
            _builder.append((Object)_domainElementConstraintMethod);
        }
        return _builder;
    }

    protected CharSequence _domainElementConstraintMethod(GenExpressionProviderBase it, GenCommonBase diagramElement, ValueExpression expression, GenClass context) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("Constraint method is not supported for " + it);
        return _builder;
    }

    protected CharSequence _domainElementConstraintMethod(GenJavaExpressionProvider it, GenCommonBase diagramElement, ValueExpression expression, GenClass context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        if (diagramElement instanceof GenLink) {
            _builder.append("private static boolean ");
            CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(diagramElement);
            _builder.append((Object)_domainElementConstraintMethodName);
            _builder.append("(");
            CharSequence _QualifiedClassName = this._metaModel.QualifiedClassName((GenClassifier)context);
            _builder.append((Object)_QualifiedClassName);
            _builder.append(" domainElement) {");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("private static boolean ");
            CharSequence _domainElementConstraintMethodName_1 = this.domainElementConstraintMethodName(diagramElement);
            _builder.append((Object)_domainElementConstraintMethodName_1);
            _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, ");
            CharSequence _QualifiedClassName_1 = this._metaModel.QualifiedClassName((GenClassifier)context);
            _builder.append((Object)_QualifiedClassName_1);
            _builder.append(" domainElement) {");
            _builder.newLineIfNotEmpty();
        }
        if (it.isInjectExpressionBody() && expression.getBody() != null && expression.getBody().length() != 0) {
            String _body = expression.getBody();
            _builder.append(_body);
            _builder.newLineIfNotEmpty();
        } else if (it.isThrowException() || it.isInjectExpressionBody() && (expression.getBody() == null || expression.getBody().length() == 0)) {
            _builder.append("// FIXME: implement this method ");
            _builder.newLine();
            _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
            _builder.newLine();
            _builder.append("throw new java.lang.UnsupportedOperationException(\"No java implementation provided in '");
            CharSequence _domainElementConstraintMethodName_2 = this.domainElementConstraintMethodName(diagramElement);
            _builder.append((Object)_domainElementConstraintMethodName_2);
            _builder.append("' operation\");");
            CharSequence _nonNLS = this._common.nonNLS();
            _builder.append((Object)_nonNLS);
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("return false;");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _domainElementConstraintMethod(GenExpressionInterpreter it, GenCommonBase diagramElement, ValueExpression expression, GenClass context) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static boolean ");
        CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(diagramElement);
        _builder.append((Object)_domainElementConstraintMethodName);
        _builder.append("(");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)context);
        _builder.append((Object)_QualifiedClassName);
        _builder.append(" domainElement) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Object result = ");
        CharSequence _expression = this.xptGetExpression.getExpression((GenExpressionProviderBase)it, expression, context);
        _builder.append((Object)_expression, "\t");
        _builder.append(".evaluate(domainElement);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return result instanceof Boolean && ((Boolean)result).booleanValue();");
        _builder.newLine();
        _builder.append("}\t\t\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence unrecognizedVID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return \"\"; ");
        CharSequence _nonNLS = this._common.nonNLS();
        _builder.append((Object)_nonNLS);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence checkNodeVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static boolean ");
        CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
        _builder.append((Object)_checkNodeVisualIDMethodName);
        _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement, String candidate) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (candidate == null){");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// unrecognized id is always bad");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("String basic = ");
        CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
        _builder.append((Object)_nodeVisualIDMethodName, "\t");
        _builder.append("(containerView, domainElement);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return candidate.equals(basic);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isCompartmentVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static boolean ");
        CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
        _builder.append((Object)_isCompartmentVisualIDMethodName);
        _builder.append("(String visualID) {");
        _builder.newLineIfNotEmpty();
        boolean _notEmpty = this._common_qvto.notEmpty(it.getCompartments());
        if (_notEmpty) {
            _builder.append("\t");
            _builder.append("if (visualID != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("switch (visualID) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            EList _compartments = it.getCompartments();
            for (GenCompartment compartment : _compartments) {
                CharSequence _caseVisualID = this.caseVisualID((GenCommonBase)compartment);
                _builder.append((Object)_caseVisualID, "\t\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String isSemanticLeafVisualID(GenDiagram it) {
        Functions.Function1 _function = n -> IterableExtensions.isEmpty(this._utils_qvto.getSemanticChildren((GenContainerBase)n)) && IterableExtensions.forall((Iterable)n.getCompartments(), c -> IterableExtensions.isEmpty(this._utils_qvto.getSemanticChildren((GenContainerBase)c)));
        Functions.Function1 _function_1 = n -> n.getVisualID();
        List leafs = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)it.getAllNodes(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static boolean ");
        CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
        _builder.append((Object)_isSemanticLeafVisualIDMethodName);
        _builder.append("(String visualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (visualID != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch (visualID) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _caseVisualID = this.caseVisualID((GenCommonBase)it);
        _builder.append((Object)_caseVisualID, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("return false;");
        _builder.newLine();
        boolean _notEmpty = this._common_qvto.notEmpty(leafs);
        if (_notEmpty) {
            _builder.append("\t\t\t");
            for (GenNode leaf : leafs) {
                CharSequence _caseVisualID_1 = this.caseVisualID((GenCommonBase)leaf);
                _builder.append((Object)_caseVisualID_1, "\t\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("return true;");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public CharSequence runtimeTypedInstance(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static final org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure ");
        CharSequence _runtimeTypedInstanceName = this.runtimeTypedInstanceName(it);
        _builder.append((Object)_runtimeTypedInstanceName);
        _builder.append(" = new org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
        _builder.append((Object)_overrideC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public String ");
        CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
        _builder.append((Object)_visualIdMethodName, "\t");
        _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
        _builder.append((Object)_visualIDMethodCall, "\t\t");
        _builder.append("(view);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideC_1 = this.xptCodeStyle.overrideC(it);
        _builder.append((Object)_overrideC_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public String ");
        CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
        _builder.append((Object)_modelIDMethodName, "\t");
        _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
        _builder.append((Object)_modelIDMethodCall, "\t\t");
        _builder.append("(view);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideC_2 = this.xptCodeStyle.overrideC(it);
        _builder.append((Object)_overrideC_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public String ");
        CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
        _builder.append((Object)_nodeVisualIDMethodName, "\t");
        _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        CharSequence _nodeVisualIDMethodCall = this.getNodeVisualIDMethodCall(it);
        _builder.append((Object)_nodeVisualIDMethodCall, "\t\t");
        _builder.append("(containerView, domainElement);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideC_3 = this.xptCodeStyle.overrideC(it);
        _builder.append((Object)_overrideC_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public boolean ");
        CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
        _builder.append((Object)_checkNodeVisualIDMethodName, "\t");
        _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement, String candidate) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        CharSequence _checkNodeVisualIDMethodCall = this.checkNodeVisualIDMethodCall(it);
        _builder.append((Object)_checkNodeVisualIDMethodCall, "\t\t");
        _builder.append("(containerView, domainElement, candidate);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideC_4 = this.xptCodeStyle.overrideC(it);
        _builder.append((Object)_overrideC_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public boolean ");
        CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
        _builder.append((Object)_isCompartmentVisualIDMethodName, "\t");
        _builder.append("(String visualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        CharSequence _isCompartmentVisualIDMethodCall = this.isCompartmentVisualIDMethodCall(it);
        _builder.append((Object)_isCompartmentVisualIDMethodCall, "\t\t");
        _builder.append("(visualID);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideC_5 = this.xptCodeStyle.overrideC(it);
        _builder.append((Object)_overrideC_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public boolean ");
        CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
        _builder.append((Object)_isSemanticLeafVisualIDMethodName, "\t");
        _builder.append("(String visualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        CharSequence _isSemanticLeafVisualIDMethodCall = this.isSemanticLeafVisualIDMethodCall(it);
        _builder.append((Object)_isSemanticLeafVisualIDMethodCall, "\t\t");
        _builder.append("(visualID);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    public CharSequence caseVisualID(GenCommonBase xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("case ");
        CharSequence _visualID = VisualIDRegistry.visualID(xptSelf);
        _builder.append((Object)_visualID);
        _builder.append(":");
        return _builder;
    }

    public Iterable<GenCommonBase> getEssentialVisualChildren(GenCommonBase it) {
        if (it instanceof GenNode) {
            return this._getEssentialVisualChildren((GenNode)it);
        }
        if (it instanceof GenLink) {
            return this._getEssentialVisualChildren((GenLink)it);
        }
        if (it instanceof GenContainerBase) {
            return this._getEssentialVisualChildren((GenContainerBase)it);
        }
        if (it != null) {
            return this._getEssentialVisualChildren(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence checkSemanticElement(GenCommonBase it) {
        if (it instanceof GenNode) {
            return this._checkSemanticElement((GenNode)it);
        }
        if (it instanceof GenDiagram) {
            return this._checkSemanticElement((GenDiagram)it);
        }
        if (it instanceof GenLink) {
            return this._checkSemanticElement((GenLink)it);
        }
        if (it != null) {
            return this._checkSemanticElement(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence checkSemanticElement(LinkModelFacet it, GenLink genLink) {
        if (it instanceof TypeLinkModelFacet) {
            return this._checkSemanticElement((TypeLinkModelFacet)it, genLink);
        }
        if (it != null) {
            return this._checkSemanticElement(it, genLink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, genLink).toString());
    }

    public CharSequence constraintMethod(LinkModelFacet it, GenLink l) {
        if (it instanceof TypeLinkModelFacet) {
            return this._constraintMethod((TypeLinkModelFacet)it, l);
        }
        if (it != null) {
            return this._constraintMethod(it, l);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, l).toString());
    }

    public CharSequence domainElementConstraintMethod(GenExpressionProviderBase it, GenCommonBase diagramElement, ValueExpression expression, GenClass context) {
        if (it instanceof GenExpressionInterpreter) {
            return this._domainElementConstraintMethod((GenExpressionInterpreter)it, diagramElement, expression, context);
        }
        if (it instanceof GenJavaExpressionProvider) {
            return this._domainElementConstraintMethod((GenJavaExpressionProvider)it, diagramElement, expression, context);
        }
        if (it != null) {
            return this._domainElementConstraintMethod(it, diagramElement, expression, context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, diagramElement, expression, context).toString());
    }
}

