/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;

public class GeneralOrderingHorizontalFigure
extends PapyrusNodeFigure {
    private static final int PREFERRED_HEIGHT = 11;

    public GeneralOrderingHorizontalFigure() {
        this.setShadow(false);
        this.setBorder(null);
    }

    public void setBorder(Border border) {
        super.setBorder(null);
    }

    public void paintFigure(Graphics g) {
        g.pushState();
        int middleX = this.bounds.x + this.bounds.width / 2;
        int middleY = this.bounds.y + this.bounds.height / 2;
        int x = this.bounds.x;
        int w = this.bounds.width - 1;
        int arrowSize = Math.max(Math.min(w / 3, 12), 6);
        int a = arrowSize / 2;
        g.setLineWidth(1);
        g.setLineDash(new int[]{4, 4});
        g.drawLine(x, middleY, x + w, middleY);
        g.setLineDash(new int[0]);
        g.setAntialias(1);
        g.setBackgroundColor(this.getForegroundColor());
        g.fillPolygon(new int[]{middleX - a, this.bounds.y, middleX + a, middleY, middleX - a, this.bounds.y + this.bounds.height});
        g.popState();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(-1, 11);
    }
}

