/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.URIConverterService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class DelegatingURIConverterService
implements URIConverterService {
    private final Multimap<String, URIConverterService> delegates = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());
    private ServiceTracker<URIConverterService, URIConverterService> delegatesTracker;

    DelegatingURIConverterService() {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        this.delegatesTracker = new ServiceTracker(context, URIConverterService.class, (ServiceTrackerCustomizer)new Customizer(context));
        this.delegatesTracker.open();
    }

    @Override
    public URI normalize(URI uri, ResourceSet context) {
        URI result = context.getURIConverter().normalize(uri);
        Collection delegates = this.delegates.get((Object)uri.scheme());
        if (!delegates.isEmpty()) {
            result = this.normalize(uri, context, delegates);
        }
        return result;
    }

    private URI normalize(URI uri, ResourceSet context, Collection<URIConverterService> delegates) {
        URI result = uri;
        Iterator<URIConverterService> iter = delegates.iterator();
        while (iter.hasNext() && uri.equals(result)) {
            result = iter.next().normalize(uri, context);
        }
        return result;
    }

    private final class Customizer
    implements ServiceTrackerCustomizer<URIConverterService, URIConverterService> {
        private final BundleContext context;

        Customizer(BundleContext context) {
            this.context = context;
        }

        public URIConverterService addingService(ServiceReference<URIConverterService> reference) {
            return this.register(reference, (URIConverterService)this.context.getService(reference));
        }

        private URIConverterService register(ServiceReference<URIConverterService> reference, URIConverterService service) {
            URIConverterService result = service;
            Object schemes = reference.getProperty("papyrus.toolsmiths.uri.scheme");
            if (schemes instanceof String) {
                this.register((String)schemes, result);
            } else if (schemes instanceof String[]) {
                String[] schemeArray = (String[])schemes;
                if (schemeArray.length == 0) {
                    result = null;
                } else {
                    String[] stringArray = schemeArray;
                    int n = schemeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String scheme = stringArray[n2];
                        this.register(scheme, result);
                        ++n2;
                    }
                }
            }
            if (result == null) {
                this.context.ungetService(reference);
            }
            return result;
        }

        private void register(String scheme, URIConverterService service) {
            if (service instanceof DelegatingURIConverterService) {
                throw new IllegalArgumentException("attempt to register the delegating service to itself");
            }
            DelegatingURIConverterService.this.delegates.put((Object)scheme, (Object)service);
        }

        private void unregister(URIConverterService service) {
            DelegatingURIConverterService.this.delegates.values().removeIf(Predicate.isEqual(service));
        }

        public void modifiedService(ServiceReference<URIConverterService> reference, URIConverterService service) {
            this.unregister(service);
            this.register(reference, service);
        }

        public void removedService(ServiceReference<URIConverterService> reference, URIConverterService service) {
            this.unregister(service);
            this.context.ungetService(reference);
        }
    }
}

