/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class FileSelector {
    public static IFile selectFile(Shell shell, String description, IContainer rootElement, IFile selected) {
        return FileSelector.selectFile(shell, description, rootElement, selected, null);
    }

    public static IFile selectFile(Shell shell, String description, IContainer rootElement, IFile selected, final String fileExtension) {
        if (rootElement == null) {
            rootElement = ResourcesPlugin.getWorkspace().getRoot();
        }
        ResourceListSelectionDialog fsd = new ResourceListSelectionDialog(shell, rootElement, 1){

            protected String adjustPattern() {
                String s = super.adjustPattern();
                if (s.equals("") && fileExtension != null) {
                    s = "*." + fileExtension;
                }
                return s;
            }

            public void create() {
                super.create();
                this.refresh(true);
            }

            protected void updateOKState(boolean state) {
                super.updateOKState(true);
            }
        };
        fsd.setTitle(description);
        fsd.setAllowUserToToggleDerived(true);
        if (fsd.open() == 0) {
            Object[] result = fsd.getResult();
            selected = result != null && result.length > 0 && result[0] instanceof IFile ? (IFile)result[0] : null;
        }
        return selected;
    }
}

