/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.uml.diagram.wizards.command.PapyrusModelFromExistingDomainModelCommand;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectRepresentationKindPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectRootElementPage;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.papyrus.uml.diagram.wizards.wizards.CreateModelWizard;
import org.eclipse.ui.IWorkbench;

public class InitModelWizard
extends CreateModelWizard {
    private SelectRootElementPage selectRootElementPage;
    private boolean isInitFromExistingDomainModel;

    @Override
    public boolean isInitModelWizard() {
        return true;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        URI uri = WizardsHelper.getSelectedResourceURI(selection);
        this.isInitFromExistingDomainModel = InitModelWizard.isSupportedDomainModelResource(uri);
        super.init(workbench, selection);
        this.selectRootElementPage = this.createSelectRootElementPage(selection);
        if (this.isCreateFromExistingDomainModel()) {
            this.setWindowTitle(Messages.InitModelWizard_init_papyrus_diagram);
        }
    }

    protected SelectRootElementPage createSelectRootElementPage(IStructuredSelection selection) {
        if (!this.isCreateFromExistingDomainModel()) {
            return null;
        }
        return new SelectRootElementPage(selection);
    }

    @Override
    protected SelectRepresentationKindPage doCreateSelectRepresentationKindPage() {
        if (this.isCreateFromExistingDomainModel()) {
            return new SelectRepresentationKindPage(false, this.createContextProvider(), SelectRepresentationKindPage.DEFAULT_CREATION_COMMAND_REGISTRY);
        }
        return super.doCreateSelectRepresentationKindPage();
    }

    @Override
    public void addPages() {
        super.addPages();
    }

    public static boolean isSupportedDomainModelFile(IFile file) {
        return file != null && InitModelWizard.isSupportedDomainModelResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
    }

    public static boolean isSupportedDomainModelResource(URI uri) {
        return uri != null && "uml".equals(uri.fileExtension());
    }

    public static boolean isSupportedDomainModelFile(IStructuredSelection sselection) {
        URI uri = WizardsHelper.getSelectedResourceURI(sselection);
        return InitModelWizard.isSupportedDomainModelResource(uri);
    }

    @Override
    protected void createPapyrusModels(ModelSet modelSet, URI newURI) {
        if (this.isCreateFromExistingDomainModel()) {
            PapyrusModelFromExistingDomainModelCommand command = new PapyrusModelFromExistingDomainModelCommand(modelSet, newURI, this.getRoot());
            this.getCommandStack(modelSet).execute((Command)command);
        } else {
            super.createPapyrusModels(modelSet, newURI);
        }
    }

    @Override
    protected void initDomainModel(ModelSet modelSet, String contextId, String[] viewpointIds) {
        if (!this.isCreateFromExistingDomainModel()) {
            super.initDomainModel(modelSet, contextId, viewpointIds);
        }
    }

    @Override
    protected void initDiagrams(ModelSet modelSet, String contextName) {
        this.initDiagrams(modelSet, this.getRoot(), contextName);
    }

    public boolean isCreateFromExistingDomainModel() {
        return this.isInitFromExistingDomainModel;
    }

    @Override
    public String getDiagramFileExtension(String contextId) {
        if (this.isCreateFromExistingDomainModel()) {
            return "di";
        }
        return super.getDiagramFileExtension(contextId);
    }

    private EObject getRoot() {
        if (this.selectRootElementPage != null) {
            return SelectRepresentationKindPage.getModelRoot();
        }
        return null;
    }
}

