/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.widgets.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.gmf.runtime.common.ui.dialogs.PopupDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.Activator;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ElementDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ToolConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.editor.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.utils.CreatePaletteItemUtil;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.widgets.editors.ActionDescriptor;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceFactory;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.IDataSourceListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.properties.ui.util.PropertiesDisplayHelper;
import org.eclipse.papyrus.infra.properties.ui.widgets.CustomizablePropertyEditor;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.AdviceConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredType;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.factories.impl.AbstractAdviceBindingFactory;
import org.eclipse.papyrus.infra.types.core.utils.ElementTypeConfigurationUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class PaletteToolActionsPropertyEditor
implements CustomizablePropertyEditor,
SelectionListener {
    private Composite self;
    private DisplayEngine displayEngine;
    private static final String ICON_ARROW_DOWN = "/icons/Down_12x12.gif";
    private static final String ICON_ARROW_UP = "/icons/Up_12x12.gif";
    private static final String ICON_DELETE = "/icons/Delete_12x12.gif";
    private static final String ICON_ADD = "/icons/Add_12x12.gif";
    private DataSource input;
    private String property;
    private boolean readOnly;
    private TableViewer actionsViewer;
    private Composite propertiesComposite;
    private AdapterFactoryEditingDomain editingDomain;
    private ToolConfiguration toolSource;
    private Menu addActionsMenu;
    private Map<ToolbarButtonIds, Button> buttonsMap = new HashMap<ToolbarButtonIds, Button>();
    private List<ActionDescriptor> actionsDesciptors = new ArrayList<ActionDescriptor>();
    private ElementTypeSetConfiguration elementTypeSetConfigurationSemantic;
    protected List<String> blackListedAdvice = new ArrayList<String>(Collections.singleton("Set type"));
    private IDataSourceListener dataSourceListener;
    private boolean standaloneEditor = false;

    public PaletteToolActionsPropertyEditor(Composite parent, int style) {
        this.self = new Composite(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.self.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 1;
        this.self.setLayoutData((Object)data);
        this.createActionsPreviewGroup();
        this.createActionsPropertiesGroup();
        this.addDisposeListener((Control)this.self);
    }

    protected void addDisposeListener(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PaletteToolActionsPropertyEditor.this.disposeDisplayEngine();
            }
        });
    }

    protected void disposeDisplayEngine() {
        if (this.displayEngine != null) {
            this.displayEngine.dispose();
            this.displayEngine = null;
        }
    }

    protected void createActionsPropertiesGroup() {
        Composite parent = this.getControl();
        this.propertiesComposite = new Composite(parent, 0);
        parent.getParent().setLayoutData((Object)new GridData(4, 4, true, true));
        FillLayout layout = new FillLayout(512);
        layout.marginHeight = -5;
        layout.marginWidth = -5;
        this.propertiesComposite.setLayout((Layout)layout);
        this.propertiesComposite.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected Composite getControl() {
        return this.self;
    }

    protected void createActionsPreviewGroup() {
        Composite parent = this.getControl();
        Composite actionsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        actionsComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, false, true);
        data.widthHint = 215;
        data.heightHint = 178;
        actionsComposite.setLayoutData((Object)data);
        Label label = new Label(actionsComposite, 0);
        label.setText(Messages.PaletteToolActionsPropertyEditor_AppliedActions);
        data = new GridData(4, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        Composite toolbar = new Composite(actionsComposite, 0);
        GridLayout layout2 = new GridLayout(4, true);
        layout2.horizontalSpacing = 0;
        toolbar.setLayout((Layout)layout2);
        toolbar.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.populateToolBar(toolbar);
        Table table = new Table(actionsComposite, 2820);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Button addButton = this.buttonsMap.get((Object)ToolbarButtonIds.ADD);
        if (addButton != null) {
            this.addActionsMenu = new Menu((Control)addButton);
            this.populateActionsMenu();
        }
        this.actionsViewer = new TableViewer(table);
        this.actionsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PaletteToolActionsPropertyEditor.this.handleActionsSelectionChanged(event);
            }
        });
        this.handleActionsSelectionChanged(null);
    }

    protected void populateActionsMenu() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.types.core.adviceConfigurationKind");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                String description;
                Object factoryClass = configurationElement.createExecutableExtension("factoryClass");
                if (factoryClass instanceof AbstractAdviceBindingFactory && !this.blackListedAdvice.contains(description = this.getAdviceDesciption(configurationElement))) {
                    Image icon = this.getAdviceIcon(configurationElement);
                    Class<AdviceConfiguration> adviceInterface = ClassLoaderHelper.loadClass((String)configurationElement.getAttribute("configurationClass")).asSubclass(AdviceConfiguration.class);
                    this.actionsDesciptors.add(new ActionDescriptor(adviceInterface, icon, description));
                    this.createMenuItem(icon, description, factoryClass);
                }
            }
            catch (CoreException | InvalidRegistryObjectException e) {
                Activator.log.error(e);
            }
            ++n2;
        }
    }

    protected Image getAdviceIcon(IConfigurationElement configurationElement) {
        String iconPath = configurationElement.getAttribute("icon");
        Image icon = null;
        if (iconPath != null) {
            icon = Activator.getPluginIconImage((String)configurationElement.getContributor().getName(), (String)iconPath);
        }
        return icon;
    }

    protected String getAdviceDesciption(IConfigurationElement configurationElement) {
        String description = configurationElement.getAttribute("description");
        if (description == null || description.isEmpty()) {
            StringBuilder desc = new StringBuilder(configurationElement.getAttribute("configurationClass"));
            String newDesc = desc.substring(desc.lastIndexOf(".") + 1);
            newDesc = newDesc.replace("AdviceConfiguration", "");
            newDesc = newDesc.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
            newDesc = newDesc.toLowerCase();
            desc = new StringBuilder(newDesc);
            String firstChar = String.valueOf(newDesc.charAt(0)).toUpperCase();
            desc.replace(0, 1, firstChar);
            description = desc.toString();
        }
        return description;
    }

    protected void createMenuItem(Image image, String text, Object factory) {
        MenuItem stereotypeMenuItem = new MenuItem(this.addActionsMenu, 0);
        stereotypeMenuItem.setText(text);
        stereotypeMenuItem.setImage(image);
        stereotypeMenuItem.setData(factory);
        stereotypeMenuItem.addSelectionListener((SelectionListener)this);
    }

    protected void populateToolBar(Composite toolbar) {
        this.createButton(toolbar, Activator.getPluginIconImage((String)"org.eclipse.papyrus.infra.widgets", (String)ICON_ARROW_UP), Messages.PaletteToolActionsPropertyEditor_UpAction, ToolbarButtonIds.UP);
        this.createButton(toolbar, Activator.getPluginIconImage((String)"org.eclipse.papyrus.infra.widgets", (String)ICON_ARROW_DOWN), Messages.PaletteToolActionsPropertyEditor_DownAction, ToolbarButtonIds.DOWN);
        this.createButton(toolbar, Activator.getPluginIconImage((String)"org.eclipse.papyrus.infra.widgets", (String)ICON_ADD), Messages.PaletteToolActionsPropertyEditor_AddAction, ToolbarButtonIds.ADD);
        this.createButton(toolbar, Activator.getPluginIconImage((String)"org.eclipse.papyrus.infra.widgets", (String)ICON_DELETE), Messages.PaletteToolActionsPropertyEditor_RemoveAction, ToolbarButtonIds.DELETE);
    }

    protected void createButton(Composite parent, Image image, String toolTipText, ToolbarButtonIds buttonId) {
        Button button = new Button(parent, 8);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)this);
        button.setToolTipText(toolTipText);
        button.setData((Object)buttonId);
        this.buttonsMap.put(buttonId, button);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void widgetSelected(SelectionEvent event) {
        MenuItem selectedItem;
        Object data;
        Command command = null;
        if (event.getSource() instanceof Button) {
            Button selectedButton = (Button)event.getSource();
            Object data2 = selectedButton.getData();
            if (data2 instanceof ToolbarButtonIds) {
                ToolbarButtonIds buttonId = (ToolbarButtonIds)((Object)data2);
                switch (buttonId) {
                    case UP: {
                        command = this.getUpActionCommand();
                        break;
                    }
                    case DOWN: {
                        command = this.getDownActionCommand();
                        break;
                    }
                    case ADD: {
                        if (this.addActionsMenu == null) break;
                        this.addActionsMenu.setVisible(true);
                        break;
                    }
                    case DELETE: {
                        command = this.getDeleteActionCommand();
                        if (this.displayEngine == null) break;
                        this.displayEngine.removeSection(this.propertiesComposite);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (event.getSource() instanceof MenuItem && (data = (selectedItem = (MenuItem)event.getSource()).getData()) instanceof AbstractAdviceBindingFactory) {
            command = this.getCreateActionCommand((AbstractAdviceBindingFactory)data);
        }
        if (command != null && command.canExecute()) {
            this.editingDomain.getCommandStack().execute(command);
        }
        this.refresh();
    }

    protected Command getCreateActionCommand(AbstractAdviceBindingFactory<?> adviceFactory) {
        AddCommand command = null;
        ElementTypeConfiguration semanticElementType = this.getSemanticElementTypeFromTool(this.toolSource);
        AbstractAdviceBindingConfiguration newAdvice = null;
        newAdvice = adviceFactory.createAdviceBindingConfiguration();
        if (newAdvice != null) {
            newAdvice.setTarget(semanticElementType);
            newAdvice.setIdentifier(CreatePaletteItemUtil.generateID((String)semanticElementType.getIdentifier()));
            command = new AddCommand((EditingDomain)this.editingDomain, this.elementTypeSetConfigurationSemantic.getAdviceBindingsConfigurations(), (Object)newAdvice);
        }
        return command;
    }

    protected Command getDeleteActionCommand() {
        Object firstElement;
        RemoveCommand command = null;
        ISelection selection = this.actionsViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof AbstractAdviceBindingConfiguration) {
            command = new RemoveCommand((EditingDomain)this.editingDomain, this.elementTypeSetConfigurationSemantic.getAdviceBindingsConfigurations(), firstElement);
        }
        return command;
    }

    protected Command getDownActionCommand() {
        MoveCommand command = null;
        ISelection selection = this.actionsViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof StructuredSelection) {
            Object actionToMove = ((StructuredSelection)selection).getFirstElement();
            EList adviceBindingsConfigurations = this.elementTypeSetConfigurationSemantic.getAdviceBindingsConfigurations();
            List<Object> elements = Arrays.asList(((IStructuredContentProvider)this.actionsViewer.getContentProvider()).getElements((Object)this.toolSource));
            int indexInActionsList = elements.indexOf(actionToMove);
            if (elements.size() - 1 > indexInActionsList) {
                Object actionToReplace = elements.get(indexInActionsList + 1);
                int targetIndex = adviceBindingsConfigurations.indexOf(actionToReplace);
                command = new MoveCommand((EditingDomain)this.editingDomain, adviceBindingsConfigurations, actionToMove, targetIndex);
            }
        }
        return command;
    }

    protected Command getUpActionCommand() {
        MoveCommand command = null;
        ISelection selection = this.actionsViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof StructuredSelection) {
            Object actionToMove = ((StructuredSelection)selection).getFirstElement();
            EList adviceBindingsConfigurations = this.elementTypeSetConfigurationSemantic.getAdviceBindingsConfigurations();
            List<Object> elements = Arrays.asList(((IStructuredContentProvider)this.actionsViewer.getContentProvider()).getElements((Object)this.toolSource));
            int indexInActionsList = elements.indexOf(actionToMove);
            if (indexInActionsList > 0) {
                Object actionToReplace = elements.get(indexInActionsList - 1);
                int targetIndex = adviceBindingsConfigurations.indexOf(actionToReplace);
                command = new MoveCommand((EditingDomain)this.editingDomain, adviceBindingsConfigurations, actionToMove, targetIndex);
            }
        }
        return command;
    }

    protected ElementTypeConfiguration getSemanticElementTypeFromTool(ToolConfiguration tool) {
        ElementDescriptor elementDescriptor;
        ElementTypeConfiguration elementTypeConfiguration;
        EList elementDescriptors = tool.getElementDescriptors();
        ElementTypeConfiguration elementTypeFound = null;
        if (!elementDescriptors.isEmpty() && (elementTypeConfiguration = (elementDescriptor = (ElementDescriptor)elementDescriptors.get(0)).getElementType()) instanceof SpecializationTypeConfiguration) {
            elementTypeFound = !this.standaloneEditor && !(((SpecializationTypeConfiguration)elementTypeConfiguration).getSpecializedTypes().get(0) instanceof ExternallyRegisteredType) ? (ElementTypeConfiguration)((SpecializationTypeConfiguration)elementTypeConfiguration).getSpecializedTypes().get(0) : elementTypeConfiguration;
        }
        return elementTypeFound;
    }

    protected void initActionsViewer() {
        this.actionsViewer.setContentProvider((IContentProvider)new ActionsContentProvider());
        this.actionsViewer.setLabelProvider((IBaseLabelProvider)new ActionsLabelProvider());
        this.actionsViewer.setInput((Object)this.toolSource);
        this.refresh();
    }

    protected void handleActionsSelectionChanged(SelectionChangedEvent event) {
        Object firstSelected;
        ISelection selection;
        if (event != null && (selection = event.getSelection()) instanceof IStructuredSelection && (firstSelected = ((IStructuredSelection)selection).getFirstElement()) != null) {
            Control[] controlArray = this.propertiesComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            if (!PropertiesRuntime.getConstraintEngine().getDisplayUnits(firstSelected).isEmpty()) {
                this.displayEngine = PropertiesDisplayHelper.display((Object)firstSelected, (Composite)this.propertiesComposite);
            } else {
                ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain);
                propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(this.editingDomain.getAdapterFactory()));
                propertySheetPage.createControl(this.propertiesComposite);
                propertySheetPage.selectionChanged(null, selection);
            }
            this.propertiesComposite.layout();
        }
        this.refreshButtons();
    }

    protected void refreshButtons() {
        if (!this.readOnly) {
            this.buttonsMap.get((Object)ToolbarButtonIds.UP).setEnabled(this.getUpActionCommand() != null);
            this.buttonsMap.get((Object)ToolbarButtonIds.DOWN).setEnabled(this.getDownActionCommand() != null);
            this.buttonsMap.get((Object)ToolbarButtonIds.DELETE).setEnabled(this.getDeleteActionCommand() != null);
        }
    }

    public DataSource getInput() {
        return this.input;
    }

    public void setInput(DataSource input) {
        DataSource oldInput = this.input;
        if (input != oldInput) {
            if (oldInput != null) {
                this.unhookDataSourceListener(oldInput);
            }
            this.input = input;
            if (input != null) {
                this.hookDataSourceListener(input);
            }
            this.initialize();
        }
    }

    protected void unhookDataSourceListener(DataSource oldInput) {
        oldInput.removeDataSourceListener(this.getDataSourceListener());
    }

    protected void hookDataSourceListener(DataSource newInput) {
        newInput.addDataSourceListener(this.getDataSourceListener());
    }

    private IDataSourceListener getDataSourceListener() {
        if (this.dataSourceListener == null) {
            this.dataSourceListener = new IDataSourceListener(){

                public void dataSourceChanged(DataSourceChangedEvent event) {
                    PaletteToolActionsPropertyEditor.this.initialize();
                    PaletteToolActionsPropertyEditor.this.actionsViewer.refresh();
                    Object elementAt = PaletteToolActionsPropertyEditor.this.actionsViewer.getElementAt(0);
                    if (elementAt != null) {
                        PaletteToolActionsPropertyEditor.this.actionsViewer.setSelection((ISelection)new StructuredSelection(elementAt));
                    } else {
                        Control[] controlArray = PaletteToolActionsPropertyEditor.this.propertiesComposite.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control control = controlArray[n2];
                            control.dispose();
                            ++n2;
                        }
                    }
                }
            };
        }
        return this.dataSourceListener;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
        this.initialize();
    }

    protected void initialize() {
        ModelElement modelElement;
        if (this.property != null && this.input != null && (modelElement = DataSourceFactory.instance.getModelElementFromPropertyPath(this.input, this.property)) instanceof EMFModelElement) {
            this.setEditingDomain((AdapterFactoryEditingDomain)((EMFModelElement)modelElement).getDomain());
            this.setToolSource(modelElement);
            this.setElementTypeModels();
            this.initActionsViewer();
        }
    }

    protected void setToolSource(ModelElement modelElement) {
        if (((EMFModelElement)modelElement).getSource() instanceof ToolConfiguration) {
            this.toolSource = (ToolConfiguration)((EMFModelElement)modelElement).getSource();
        }
    }

    protected void setElementTypeModels() {
        Object SemanticRessource = this.editingDomain.getResourceSet().getLoadOptions().get("resourceElementTypeSemantic");
        EObject SemanticModel = null;
        if (SemanticRessource instanceof Resource && !((Resource)SemanticRessource).getContents().isEmpty()) {
            SemanticModel = (EObject)((Resource)SemanticRessource).getContents().get(0);
        }
        if (SemanticModel instanceof ElementTypeSetConfiguration) {
            this.elementTypeSetConfigurationSemantic = (ElementTypeSetConfiguration)SemanticModel;
        } else {
            List writableElementTypes = this.toolSource.getElementDescriptors().stream().map(ed -> ed.getElementType()).filter(elt -> !EMFHelper.isReadOnly((EObject)elt)).collect(Collectors.toList());
            List<Object> elementTypes = new ArrayList();
            elementTypes.addAll(writableElementTypes);
            do {
                elementTypes = elementTypes.stream().filter(SpecializationTypeConfiguration.class::isInstance).map(SpecializationTypeConfiguration.class::cast).flatMap(elt -> elt.getSpecializedTypes().stream()).map(ElementTypeConfiguration.class::cast).filter(elt -> !EMFHelper.isReadOnly((EObject)elt)).collect(Collectors.toList());
                writableElementTypes.addAll(elementTypes);
            } while (!elementTypes.isEmpty());
            List elementTypeSetConfiguration = writableElementTypes.stream().map(elt -> elt.eContainer()).filter(ElementTypeSetConfiguration.class::isInstance).map(ElementTypeSetConfiguration.class::cast).distinct().collect(Collectors.toList());
            LabelProvider labelProvider = new LabelProvider(){

                public String getText(Object element) {
                    String text = element instanceof ElementTypeSetConfiguration ? ((ElementTypeSetConfiguration)element).getIdentifier() : super.getText(element);
                    return text;
                }
            };
            PopupDialog dialog = new PopupDialog(Display.getCurrent().getActiveShell(), elementTypeSetConfiguration, (ILabelProvider)labelProvider);
            dialog.setMessage(Messages.PaletteToolActionsPropertyEditor_selectElementTypeSetModelMessage);
            dialog.setTitle(Messages.PaletteToolActionsPropertyEditor_selectElementTypeSetModelTitle);
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length > 0) {
                this.elementTypeSetConfigurationSemantic = (ElementTypeSetConfiguration)result[0];
                this.editingDomain.getResourceSet().getLoadOptions().put("resourceElementTypeSemantic", this.elementTypeSetConfigurationSemantic.eResource());
                this.standaloneEditor = true;
                this.setReadOnly(false);
            } else {
                this.setReadOnly(true);
            }
        }
    }

    public void setEditingDomain(AdapterFactoryEditingDomain editingDomain) {
        if (editingDomain != null) {
            this.editingDomain = editingDomain;
        }
    }

    public EditingDomain getDomain() {
        return this.editingDomain;
    }

    public boolean getShowLabel() {
        return true;
    }

    public void setShowLabel(boolean showLabel) {
    }

    public String getCustomLabel() {
        return null;
    }

    public void setCustomLabel(String customLabel) {
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly != this.readOnly) {
            this.buttonsMap.values().stream().forEach(button -> button.setEnabled(!readOnly));
        }
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void refresh() {
        this.actionsViewer.refresh();
        Object elementAt = this.actionsViewer.getElementAt(0);
        if (elementAt != null) {
            this.actionsViewer.setSelection((ISelection)new StructuredSelection(elementAt));
        }
        this.refreshButtons();
    }

    private class ActionsContentProvider
    implements IStructuredContentProvider {
        private static final String SOURCE_ECLASS = "sourceEClass";

        private ActionsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ElementTypeConfiguration elementType;
            ArrayList actions = new ArrayList();
            if (!PaletteToolActionsPropertyEditor.this.toolSource.getElementDescriptors().isEmpty() && PaletteToolActionsPropertyEditor.this.elementTypeSetConfigurationSemantic != null && (elementType = ((ElementDescriptor)PaletteToolActionsPropertyEditor.this.toolSource.getElementDescriptors().get(0)).getElementType()) instanceof SpecializationTypeConfiguration) {
                PaletteToolActionsPropertyEditor.this.editingDomain.getResourceSet().getLoadOptions().put(SOURCE_ECLASS, ElementTypeConfigurationUtil.getFirstCreatedElementEClass((SpecializationTypeConfiguration)((SpecializationTypeConfiguration)elementType)));
                actions.addAll(PaletteToolActionsPropertyEditor.this.elementTypeSetConfigurationSemantic.getAdviceBindingsConfigurations().stream().filter(p -> p.getTarget() != null && ElementTypeConfigurationUtil.isTypeOf((ElementTypeConfiguration)elementType, (ElementTypeConfiguration)p.getTarget())).collect(Collectors.toList()));
            }
            return actions.toArray();
        }
    }

    private class ActionsLabelProvider
    extends LabelProvider {
        private ActionsLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = null;
            for (ActionDescriptor actionDescriptor : PaletteToolActionsPropertyEditor.this.actionsDesciptors) {
                if (!actionDescriptor.getAdvice().isInstance(element)) continue;
                image = actionDescriptor.getImage();
            }
            return image;
        }

        public String getText(Object element) {
            String text = Messages.PaletteToolActionsPropertyEditor_invalidAdvice;
            for (ActionDescriptor actionDescriptor : PaletteToolActionsPropertyEditor.this.actionsDesciptors) {
                if (!actionDescriptor.getAdvice().isInstance(element)) continue;
                text = actionDescriptor.getDescription();
            }
            return text;
        }
    }

    private static enum ToolbarButtonIds {
        UP,
        DOWN,
        ADD,
        DELETE;

    }
}

