/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.importt.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.library.FilteredRegisteredLibrariesSelectionDialog;
import org.eclipse.papyrus.uml.extensionpoints.library.IRegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.importt.handlers.AbstractImportHandler;
import org.eclipse.papyrus.uml.importt.ui.PackageImportDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ElementImportTreeSelectionDialog;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;

public class ImportRegisteredPackageHandler
extends AbstractImportHandler {
    @Override
    protected ICommand getGMFCommand(IEvaluationContext context) {
        return new ImportLibraryFromRepositoryCommand(context);
    }

    protected void importLibraries(IRegisteredLibrary[] librariesToImport) {
        ResourceSet resourceSet = Util.createTemporaryResourceSet();
        try {
            int i = 0;
            while (i < librariesToImport.length) {
                IRegisteredLibrary currentLibrary = librariesToImport[i];
                URI modelUri = currentLibrary.getUri();
                Resource modelResource = resourceSet.getResource(modelUri, true);
                PackageImportDialog dialog = new PackageImportDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Package)modelResource.getContents().get(0));
                if (dialog.open() == 0) {
                    Collection result = dialog.getResult();
                    for (ElementImportTreeSelectionDialog.ImportSpec resultElement : result) {
                        Package selectedPackage = (Package)resultElement.getElement();
                        switch (resultElement.getAction()) {
                            case COPY: {
                                this.handleCopyPackage(selectedPackage);
                                break;
                            }
                            case IMPORT: {
                                this.handleImportPackage(selectedPackage);
                                break;
                            }
                            default: {
                                this.handleLoadPackage(selectedPackage);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            EMFHelper.unload((ResourceSet)resourceSet);
        }
    }

    protected IRegisteredLibrary[] getAvailableLibraries() {
        ArrayList<IRegisteredLibrary> libraries = new ArrayList<IRegisteredLibrary>();
        IRegisteredLibrary[] allLibraries = Registry.getRegisteredLibraries().toArray(new IRegisteredLibrary[0]);
        int i = 0;
        while (i < allLibraries.length) {
            IRegisteredLibrary registeredLibrary = allLibraries[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)((Package)this.getSelectedElement()));
            if (!importedPackageNames.contains(registeredLibrary.getName())) {
                libraries.add(registeredLibrary);
            }
            ++i;
        }
        return libraries.toArray(new IRegisteredLibrary[libraries.size()]);
    }

    protected Collection<IRegisteredLibrary> getImportedLibraries() {
        ArrayList<IRegisteredLibrary> libraries = new ArrayList<IRegisteredLibrary>();
        IRegisteredLibrary[] allLibraries = Registry.getRegisteredLibraries().toArray(new IRegisteredLibrary[0]);
        int i = 0;
        while (i < allLibraries.length) {
            IRegisteredLibrary registeredLibrary = allLibraries[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)((Package)this.getSelectedElement()));
            if (importedPackageNames.contains(registeredLibrary.getName())) {
                libraries.add(registeredLibrary);
            }
            ++i;
        }
        return libraries;
    }

    public class ImportLibraryFromRepositoryCommand
    extends AbstractImportHandler.AbstractImportCommand {
        public ImportLibraryFromRepositoryCommand(IEvaluationContext context) {
            super(ImportRegisteredPackageHandler.this, new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    Object[] allLibraries = Registry.getRegisteredLibraries().toArray(new IRegisteredLibrary[0]);
                    FilteredRegisteredLibrariesSelectionDialog dialog = new FilteredRegisteredLibrariesSelectionDialog(shell, true, allLibraries, ImportRegisteredPackageHandler.this.getImportedLibraries());
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        List<Object> librariesToImport = Arrays.asList(dialog.getResult());
                        ImportRegisteredPackageHandler.this.importLibraries(librariesToImport.toArray(new IRegisteredLibrary[librariesToImport.size()]));
                    }
                }
            }, context, "Import Libraries", "Import Libraries from Repository");
        }
    }
}

