/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.emf.types.constraints.AnyReference;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdvicePackage;
import org.eclipse.papyrus.infra.emf.types.constraints.ReferenceKind;
import org.eclipse.papyrus.infra.emf.types.constraints.provider.ReferencePermissionItemProvider;

public class AnyReferenceItemProvider
extends ReferencePermissionItemProvider {
    public AnyReferenceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addReferenceKindPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addReferenceKindPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AnyReference_referenceKind_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AnyReference_referenceKind_feature", "_UI_AnyReference_type"), (EStructuralFeature)ConstraintAdvicePackage.Literals.ANY_REFERENCE__REFERENCE_KIND, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/AnyReference"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        AnyReference anyReference = (AnyReference)object;
        return String.valueOf(switch (anyReference.getReferenceKind()) {
            case ReferenceKind.CONTAINMENT -> this.getString("_UI_AnyReference_type_containment");
            case ReferenceKind.CROSS -> this.getString("_UI_AnyReference_type_cross");
            default -> this.getString("_UI_AnyReference_type");
        }) + " " + this.getString(anyReference.isPermitted() ? "_UI_ReferencePermission_granted" : "_UI_ReferencePermission_denied");
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(AnyReference.class)) {
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

