/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css3.ui.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.decoration.ConnectionDecorationRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart;
import org.eclipse.papyrus.infra.gmfdiag.css.service.StylingService;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.AttributeSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.IdentifierTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_declaration;
import org.eclipse.papyrus.infra.gmfdiag.css3.ui.contentassist.AbstractCSSProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class CustomCSSProposalProvider
extends AbstractCSSProposalProvider {
    static final Set<String> colorNames = new LinkedHashSet<String>();
    static final Set<String> semanticProperties;

    static {
        colorNames.add("aliceblue");
        colorNames.add("aqua");
        colorNames.add("aquamarine");
        colorNames.add("azure");
        colorNames.add("beige");
        colorNames.add("bisque");
        colorNames.add("black");
        colorNames.add("blanchedalmond");
        colorNames.add("blue");
        colorNames.add("blueviolet");
        colorNames.add("brown");
        colorNames.add("burlywood");
        colorNames.add("cadetblue");
        colorNames.add("chartreuse");
        colorNames.add("chocolate");
        colorNames.add("coral");
        colorNames.add("cornflowerblue");
        colorNames.add("cornsilk");
        colorNames.add("crimson");
        colorNames.add("cyan");
        colorNames.add("darkblue");
        colorNames.add("darkcyan");
        colorNames.add("darkgoldenrod");
        colorNames.add("darkgray");
        colorNames.add("darkgrey");
        colorNames.add("darkgreen");
        colorNames.add("darkkhaki");
        colorNames.add("darkmagenta");
        colorNames.add("darkolivegreen");
        colorNames.add("darkorange");
        colorNames.add("darkorchid");
        colorNames.add("darkred");
        colorNames.add("darksalmon");
        colorNames.add("darkseagreen");
        colorNames.add("darkslateblue");
        colorNames.add("darkslategray");
        colorNames.add("darkslategrey");
        colorNames.add("darkturquoise");
        colorNames.add("darkviolet");
        colorNames.add("deeppink");
        colorNames.add("deepskyblue");
        colorNames.add("dimgray");
        colorNames.add("dimgrey");
        colorNames.add("dodgerblue");
        colorNames.add("firebrick");
        colorNames.add("floralwhite");
        colorNames.add("forestgreen");
        colorNames.add("fuchsia");
        colorNames.add("gainsboro");
        colorNames.add("ghostwhite");
        colorNames.add("gold");
        colorNames.add("goldenrod");
        colorNames.add("gray");
        colorNames.add("grey");
        colorNames.add("green");
        colorNames.add("greenyellow");
        colorNames.add("honeydew");
        colorNames.add("hotpink");
        colorNames.add("indianred");
        colorNames.add("indigo");
        colorNames.add("ivory");
        colorNames.add("khaki");
        colorNames.add("lavender");
        colorNames.add("lavenderblush");
        colorNames.add("lawngreen");
        colorNames.add("lemonchiffon");
        colorNames.add("lightblue");
        colorNames.add("lightcoral");
        colorNames.add("lightcyan");
        colorNames.add("lightgoldenrodyellow");
        colorNames.add("lightgray");
        colorNames.add("lightgrey");
        colorNames.add("lightgreen");
        colorNames.add("lightpink");
        colorNames.add("lightsalmon");
        colorNames.add("lightseagreen");
        colorNames.add("lightskyblue");
        colorNames.add("lightslategray");
        colorNames.add("lightslategrey");
        colorNames.add("lightsteelblue");
        colorNames.add("lightyellow");
        colorNames.add("lime");
        colorNames.add("limegreen");
        colorNames.add("linen");
        colorNames.add("magenta");
        colorNames.add("maroon");
        colorNames.add("mediumaquamarine");
        colorNames.add("mediumblue");
        colorNames.add("mediumorchid");
        colorNames.add("mediumpurple");
        colorNames.add("mediumseagreen");
        colorNames.add("mediumslateblue");
        colorNames.add("mediumspringgreen");
        colorNames.add("mediumturquoise");
        colorNames.add("mediumvioletred");
        colorNames.add("midnightblue");
        colorNames.add("mintcream");
        colorNames.add("mistyrose");
        colorNames.add("moccasin");
        colorNames.add("navajowhite");
        colorNames.add("navy");
        colorNames.add("oldlace");
        colorNames.add("olive");
        colorNames.add("olivedrab");
        colorNames.add("orange");
        colorNames.add("orangered");
        colorNames.add("orchid");
        colorNames.add("palegoldenrod");
        colorNames.add("palegreen");
        colorNames.add("paleturquoise");
        colorNames.add("palevioletred");
        colorNames.add("papayawhip");
        colorNames.add("peachpuff");
        colorNames.add("peru");
        colorNames.add("pink");
        colorNames.add("plum");
        colorNames.add("powderblue");
        colorNames.add("purple");
        colorNames.add("red");
        colorNames.add("rosybrown");
        colorNames.add("royalblue");
        colorNames.add("saddlebrown");
        colorNames.add("salmon");
        colorNames.add("sandybrown");
        colorNames.add("seagreen");
        colorNames.add("seashell");
        colorNames.add("sienna");
        colorNames.add("silver");
        colorNames.add("skyblue");
        colorNames.add("slateblue");
        colorNames.add("slategray");
        colorNames.add("slategrey");
        colorNames.add("snow");
        colorNames.add("springgreen");
        colorNames.add("steelblue");
        colorNames.add("tan");
        colorNames.add("teal");
        colorNames.add("thistle");
        colorNames.add("tomato");
        colorNames.add("turquoise");
        colorNames.add("violet");
        colorNames.add("wheat");
        colorNames.add("white");
        colorNames.add("whitesmoke");
        colorNames.add("yellow");
        colorNames.add("yellowgreen");
        semanticProperties = CustomCSSProposalProvider.supportedSemanticCSSClasses().flatMap(cssClass -> cssClass.getEAllStructuralFeatures().stream()).filter(StylingService.getInstance().getSemanticPropertySupportedPredicate()).map(ENamedElement::getName).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Stream<EClass> supportedSemanticCSSClasses() {
        return StreamSupport.stream(StylingService.getInstance().getSupportedSemanticClasses().spliterator(), false);
    }

    protected Collection<String> getCustomProperties() {
        String[] properties = new String[]{"transparency", "fontSize", "displayName", "elementIcon", "shadow", "qualifiedNameDepth", "lineStyle", "lineDashLength", "lineDashGap", "targetDecoration", "sourceDecoration", "maskLabel", "svgFile", "followSVGSymbol", "svgCssFile", "svgCssClass", "canonical", "imagePath", "borderStyle", "bottomMarginLabel", "displayBorder", "visible", "displayHeader", "displayStereotypes", "displayTags", "isFloatingLabelConstrained", "floatingLabelOffsetHeight", "floatingLabelOffsetWidth", "isOval", "isPackage", "labelConstrained", "labelOffsetX", "labelOffsetY", "leftMarginLabel", "lineLength", "customDash", "lineLengthRatio", "linePosition", "portPosition", "position", "radiusHeight", "radiusWidth", "rightMarginLabel", "shadowColor", "shadowWidth", "textAlignment", "topMarginLabel", "useOriginalColors", "isNameWrap", "nameBackgroundColor", "isPortResizable", "shapeStereotype", "shapeDecorationStereotype", "shapeStyle", "shapeDecorationStyle", "shapeTypedElement", "shapeDecorationTypedElement"};
        return Arrays.asList(properties);
    }

    @Override
    public void completeCss_property_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String prefix = context.getPrefix();
        HashSet<String> allProperties = new HashSet<String>(this.getStyleProperties());
        allProperties.addAll(this.getCustomProperties());
        Iterator filterIterator = allProperties.iterator();
        while (filterIterator.hasNext()) {
            if (((String)filterIterator.next()).contains(prefix)) continue;
            filterIterator.remove();
        }
        for (String property : allProperties) {
            StringBuilder stringBuilder = new StringBuilder(property);
            stringBuilder.append(": ");
            acceptor.accept((ICompletionProposal)this.buildProposal(stringBuilder.toString(), context));
        }
    }

    @Override
    public void completeAttributeSelector_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeAttributeSelector_Value(model, assignment, context, acceptor);
        if ("kind".equals(((AttributeSelector)model).getName())) {
            String[] selectorValues;
            String[] stringArray = selectorValues = new String[]{"Compartment", "Label", "FloatingLabel"};
            int n = selectorValues.length;
            int n2 = 0;
            while (n2 < n) {
                String proposal = stringArray[n2];
                acceptor.accept(this.createCompletionProposal(proposal, context));
                ++n2;
            }
        }
    }

    @Override
    public void completeAttributeSelector_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String[] attributeSelectorName;
        super.completeAttributeSelector_Name(model, assignment, context, acceptor);
        String[] stringArray = attributeSelectorName = new String[]{"appliedStereotypes"};
        int n = attributeSelectorName.length;
        int n2 = 0;
        while (n2 < n) {
            String proposal = stringArray[n2];
            acceptor.accept(this.createCompletionProposal(proposal, context));
            ++n2;
        }
    }

    protected CompletionProposal buildProposal(String proposal, ContentAssistContext context) {
        String prefix = context.getPrefix();
        return new CompletionProposal(proposal, context.getOffset() - prefix.length(), prefix.length(), proposal.length());
    }

    protected Collection<String> getStyleProperties() {
        HashSet<String> propertiesNames = new HashSet<String>();
        for (EClass styleClass : EMFHelper.getSubclassesOf((EClass)NotationPackage.eINSTANCE.getStyle(), (boolean)false)) {
            if (styleClass.getEAllSuperTypes().contains((Object)NotationPackage.eINSTANCE.getNamedStyle())) continue;
            for (EStructuralFeature styleFeature : styleClass.getEStructuralFeatures()) {
                propertiesNames.add(styleFeature.getName());
            }
        }
        return propertiesNames;
    }

    @Override
    public void completeStringTok_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeStringTok_Value(model, assignment, context, acceptor);
        if (model instanceof css_declaration || model instanceof IdentifierTok) {
            String property = null;
            String prefix = null;
            boolean autocomplete = false;
            if (model instanceof css_declaration) {
                declaration = (css_declaration)model;
                property = declaration.getProperty().getName();
                prefix = context.getPrefix();
                autocomplete = true;
            } else if (model instanceof IdentifierTok) {
                declaration = (IdentifierTok)model;
                prefix = context.getPrefix();
                if (!prefix.isEmpty()) {
                    autocomplete = true;
                }
                if (declaration.eContainer() instanceof css_declaration) {
                    property = ((css_declaration)declaration.eContainer()).getProperty().getName();
                }
            }
            if (autocomplete && property != null && (property.equals("sourceDecoration") || property.equals("targetDecoration"))) {
                Map availableDecoration = ConnectionDecorationRegistry.getInstance().getAvailableDecoration();
                ArrayList decorations = new ArrayList(availableDecoration.keySet());
                decorations.addAll(Arrays.asList(ConnectionEditPart.DECORATION_VALUES));
                for (String decoration : decorations) {
                    if (!decoration.contains(prefix)) continue;
                    acceptor.accept((ICompletionProposal)this.buildProposal(decoration, context));
                }
            }
        }
    }

    @Override
    public void completeColorTok_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeColorTok_Value(model, assignment, context, acceptor);
        if (model instanceof css_declaration || model instanceof IdentifierTok) {
            String property = null;
            String prefix = null;
            boolean autocomplete = false;
            if (model instanceof css_declaration) {
                declaration = (css_declaration)model;
                property = declaration.getProperty().getName();
                prefix = context.getPrefix();
                autocomplete = true;
            } else if (model instanceof IdentifierTok) {
                declaration = (IdentifierTok)model;
                prefix = context.getPrefix();
                if (!prefix.isEmpty()) {
                    autocomplete = true;
                }
                if (declaration.eContainer() instanceof css_declaration) {
                    property = ((css_declaration)declaration.eContainer()).getProperty().getName();
                }
            }
            if (autocomplete && property != null && (property.toLowerCase().contains("color") || property.toLowerCase().contains("gradient"))) {
                for (String colorName : colorNames) {
                    if (!colorName.contains(prefix)) continue;
                    acceptor.accept((ICompletionProposal)this.buildProposal(colorName, context));
                }
            }
        }
    }

    @Override
    public void complete_selector(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String[] otherSemanticElements;
        super.complete_selector(model, ruleCall, context, acceptor);
        CustomCSSProposalProvider.supportedSemanticCSSClasses().filter(cssClass -> cssClass.getName().contains(context.getPrefix())).forEach(cssClass -> acceptor.accept((ICompletionProposal)this.buildProposal(cssClass.getName(), context)));
        String[] stringArray = otherSemanticElements = new String[]{"Compartment", "Label", "CommentLink", "ConstraintLink", "ContextLink", "StereotypePropertyReferenceLink", "StereotypeCommentLink"};
        int n = otherSemanticElements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.contains(context.getPrefix())) {
                acceptor.accept((ICompletionProposal)this.buildProposal(element, context));
            }
            ++n2;
        }
    }

    @Override
    public void complete_Identifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof AttributeSelector) {
            String prefix = context.getPrefix();
            if (prefix.startsWith("[")) {
                prefix = prefix.substring(1);
            }
            for (String semanticProperty : semanticProperties) {
                if (!semanticProperty.contains(prefix)) continue;
                acceptor.accept((ICompletionProposal)this.buildProposal(semanticProperty, context));
            }
        } else {
            super.complete_Identifier(model, ruleCall, context, acceptor);
        }
    }
}

