/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.ContentChangedEventProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.ICurrentFolderAndPageMngr;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.PageManagerImpl;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.TransactionHelper;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;

public class TransactionalPageManagerImpl
extends PageManagerImpl {
    private EditingDomain editingDomain;

    public TransactionalPageManagerImpl(SashWindowsMngr diSashModel, ContentChangedEventProvider contentChangedEventProvider) {
        super(diSashModel, contentChangedEventProvider);
        this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)diSashModel);
    }

    public TransactionalPageManagerImpl(SashWindowsMngr diSashModel, ContentChangedEventProvider contentChangedEventProvider, ICurrentFolderAndPageMngr folderAndPageMngr) {
        super(diSashModel, contentChangedEventProvider, folderAndPageMngr);
        this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)diSashModel);
    }

    protected EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void removePage(final Object pageIdentifier) {
        try {
            TransactionHelper.run(this.getEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalPageManagerImpl.super.removePage(pageIdentifier);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public void closePage(final Object pageIdentifier) {
        try {
            TransactionHelper.run(this.getEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalPageManagerImpl.super.closePage(pageIdentifier);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public void closeAllOpenedPages() {
        try {
            TransactionHelper.run(this.getEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalPageManagerImpl.super.closeAllOpenedPages();
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public void closeOtherPages(final Object pageIdentifier) {
        try {
            TransactionHelper.run(this.getEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalPageManagerImpl.super.closeOtherPages(pageIdentifier);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void openPage(final Object pageIdentifier) {
        try {
            TransactionHelper.run(this.getEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalPageManagerImpl.super.openPage(pageIdentifier);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void openPage(final Object pageIdentifier, final String editorID) {
        try {
            TransactionHelper.run(this.getEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalPageManagerImpl.super.openPage(pageIdentifier, editorID);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void closeAllOpenedPages(final Object pageIdentifier) {
        try {
            TransactionHelper.run(this.getEditingDomain(), new Runnable(){

                @Override
                public void run() {
                    TransactionalPageManagerImpl.super.closeAllOpenedPages(pageIdentifier);
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public List<Object> allPages() {
        ResourceSet set;
        if (!this.isLegacyMode() && (set = this.editingDomain.getResourceSet()) instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)set;
            URI uri = modelSet.getURIWithoutExtension();
            ModelsReader reader = new ModelsReader();
            ArrayList<Object> result = new ArrayList<Object>();
            for (URI currentURI : reader.getKnownModelURIs(uri)) {
                String fileExtension = currentURI.fileExtension();
                if ("uml".equals(fileExtension)) continue;
                List notationResources = this.getResources(fileExtension);
                for (Resource notationResource : notationResources) {
                    for (EObject content : notationResource.getContents()) {
                        if (!this.isPage(content)) continue;
                        result.add(content);
                    }
                }
            }
            return result;
        }
        return super.allPages();
    }
}

