/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.OperationLabelProviderConfiguration;

public class LabelOperationConfigurationManagementUtils {
    private LabelOperationConfigurationManagementUtils() {
    }

    public static final OperationLabelProviderConfiguration getRowOperationLabelConfigurationInTable(Table table) {
        LocalTableHeaderAxisConfiguration config = table.getLocalRowHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getLocalColumnHeaderAxisConfiguration();
        }
        if (config != null) {
            for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
                if (!(current instanceof OperationLabelProviderConfiguration)) continue;
                return (OperationLabelProviderConfiguration)current;
            }
        }
        return null;
    }

    public static final OperationLabelProviderConfiguration getRowOperationLabelConfigurationInTableConfiguration(Table table) {
        TableHeaderAxisConfiguration config = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getTableConfiguration().getColumnHeaderAxisConfiguration();
        }
        for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
            if (!(current instanceof OperationLabelProviderConfiguration)) continue;
            return (OperationLabelProviderConfiguration)current;
        }
        return null;
    }

    public static final boolean hasRowOperationLabelConfiguration(Table table) {
        return LabelOperationConfigurationManagementUtils.getRowOperationLabelConfigurationInTable(table) != null || LabelOperationConfigurationManagementUtils.getRowOperationLabelConfigurationInTableConfiguration(table) != null;
    }

    public static final OperationLabelProviderConfiguration getColumnOperationLabelConfigurationInTable(Table table) {
        LocalTableHeaderAxisConfiguration config = table.getLocalRowHeaderAxisConfiguration();
        if (!table.isInvertAxis()) {
            config = table.getLocalColumnHeaderAxisConfiguration();
        }
        if (config != null) {
            for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
                if (!(current instanceof OperationLabelProviderConfiguration)) continue;
                return (OperationLabelProviderConfiguration)current;
            }
        }
        return null;
    }

    public static final OperationLabelProviderConfiguration getColumnOperationLabelConfigurationInTableConfiguration(Table table) {
        TableHeaderAxisConfiguration config = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        if (!table.isInvertAxis()) {
            config = table.getTableConfiguration().getColumnHeaderAxisConfiguration();
        }
        for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
            if (!(current instanceof OperationLabelProviderConfiguration)) continue;
            return (OperationLabelProviderConfiguration)current;
        }
        return null;
    }

    public static final boolean hasColumnOperationLabelConfiguration(Table table) {
        return LabelOperationConfigurationManagementUtils.getColumnOperationLabelConfigurationInTable(table) != null || LabelOperationConfigurationManagementUtils.getColumnOperationLabelConfigurationInTableConfiguration(table) != null;
    }

    public static final OperationLabelProviderConfiguration getUsedColumnOperationLabelConfiguration(Table table) {
        OperationLabelProviderConfiguration conf = LabelOperationConfigurationManagementUtils.getColumnOperationLabelConfigurationInTable(table);
        if (conf == null) {
            conf = LabelOperationConfigurationManagementUtils.getColumnOperationLabelConfigurationInTableConfiguration(table);
        }
        return conf;
    }

    public static final OperationLabelProviderConfiguration getUsedRowOperationLabelConfiguration(Table table) {
        OperationLabelProviderConfiguration conf = LabelOperationConfigurationManagementUtils.getRowOperationLabelConfigurationInTable(table);
        if (conf == null) {
            conf = LabelOperationConfigurationManagementUtils.getRowOperationLabelConfigurationInTableConfiguration(table);
        }
        return conf;
    }
}

