/**
 * Copyright (c) 2006-2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import metamodel.MetaModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class CompartmentItemSemanticEditPolicy {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private MetaModel _metaModel;
  
  @Inject
  private childContainerCreateCommand xptChildContainerCreateCommand;
  
  @Inject
  private BaseItemSemanticEditPolicy xptBaseItemSemanticEditPolicy;
  
  public CharSequence className(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    String _itemSemanticEditPolicyClassName = it.getItemSemanticEditPolicyClassName();
    _builder.append(_itemSemanticEditPolicyClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPoliciesPackageName = it.getDiagram().getEditPoliciesPackageName();
    _builder.append(_editPoliciesPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence CompartmentItemSemanticEditPolicy(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className, "\t");
    _builder.append(" extends ");
    CharSequence _qualifiedClassName = this.xptBaseItemSemanticEditPolicy.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence __constructor = this._constructor(it);
    _builder.append(__constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _childContainerCreateCommand = this.xptChildContainerCreateCommand.childContainerCreateCommand(it.getChildNodes());
    _builder.append(_childContainerCreateCommand, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence _constructor(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _defaultConstructorBody = this.xptBaseItemSemanticEditPolicy.defaultConstructorBody(it.getNode());
    _builder.append(_defaultConstructorBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence getChildNodeReference(final EList<GenChildNode> it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static Set<EReference> compartmentReferences;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("static {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("compartmentReferences = new HashSet<EReference>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        {
          for(final GenChildNode n : it) {
            _builder.append("\t");
            CharSequence _childRef = this.childRef(n.getModelFacet(), n);
            _builder.append(_childRef, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("}");
        _builder.newLine();
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2);
        _builder.newLineIfNotEmpty();
        _builder.append("protected Iterable<EReference> getCompartmentReferences() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return compartmentReferences;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence childRef(final TypeModelFacet it, final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("compartmentReferences.add(");
    CharSequence _MetaFeature = this._metaModel.MetaFeature(node.getModelFacet().getContainmentMetaFeature());
    _builder.append(_MetaFeature);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence isCorrectCompartment(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean isMovedIntoCorrectCompartment(MoveRequest req){");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for(Object entry : req.getElementsToMove().entrySet()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if(entry instanceof Map.Entry<?, ?>) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("Map.Entry<?, ?> mapEntry = (Map.Entry<?, ?>)entry;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("Object key = mapEntry.getKey();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if(key instanceof EObject) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("EObject dropppedObject = (EObject)key;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("EObject semanticHost = ((IGraphicalEditPart)getHost()).resolveSemanticElement();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("boolean foundERefrences = false;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if(semanticHost != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("for(EReference ref : getCompartmentReferences()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("if(ref.isContainment()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("foundERefrences = PackageUtil.canContain(semanticHost.eClass(), ref, dropppedObject.eClass(), false);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("foundERefrences = PackageUtil.canReference(semanticHost.eClass(), ref, dropppedObject.eClass());");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("if(foundERefrences) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constraintedMoveCommand(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("protected Command getMoveCommand(MoveRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (isMovedIntoCorrectCompartment(req)){\t\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return super.getMoveCommand(req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return UnexecutableCommand.INSTANCE;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
