/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator.strategy;

import java.util.Optional;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.DeltaStrategy;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.papyrus.uml.profile.types.generator.strategy.ElementTypeConfigHelper;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class SimpleDeltaStrategy
implements DeltaStrategy {
    @Override
    public DeltaStrategy.Diff findDiffs(Profile currentProfile, ElementTypeSetConfiguration previousTypes) {
        DeltaStrategy.DiffImpl result = new DeltaStrategy.DiffImpl();
        UML uml = new UML();
        ElementTypeConfigHelper helper = new ElementTypeConfigHelper();
        Iterable<ImpliedExtension> allExtensions = uml.getAllExtensions((Package)currentProfile);
        this.findAddedStereotypes(currentProfile, previousTypes, result, uml, helper);
        this.findRemovedStereotypesAndExtensions(currentProfile, previousTypes, result, helper, allExtensions);
        this.findRenamedSteretoypes(currentProfile, previousTypes, result, helper);
        this.findAddedExtensions(previousTypes, result, helper, allExtensions);
        return result;
    }

    private void findAddedStereotypes(Profile currentProfile, ElementTypeSetConfiguration previousTypes, DeltaStrategy.Diff result, UML uml, ElementTypeConfigHelper helper) {
        for (Stereotype stereotype : uml.getAllStereotypes((Package)currentProfile)) {
            if (helper.exists(stereotype, previousTypes)) continue;
            result.getAddedStereotypes().add(stereotype);
        }
    }

    private void findRemovedStereotypesAndExtensions(Profile currentProfile, ElementTypeSetConfiguration previousTypes, DeltaStrategy.Diff result, ElementTypeConfigHelper helper, Iterable<ImpliedExtension> allExtensions) {
        for (ElementTypeConfiguration config : previousTypes.getElementTypeConfigurations()) {
            Optional<Boolean> exists = helper.exists(config, currentProfile);
            if (exists.isEmpty()) continue;
            if (!exists.get().booleanValue()) {
                result.getRemovedStereotypes().add(helper.getStereotypeName(config));
                continue;
            }
            ImpliedExtension ext = helper.getExtension(config, currentProfile);
            if (ext == null || ext.getMetaclass() == null || ext.getStereotype() == null || helper.exists(ext, allExtensions)) continue;
            result.getRemovedExtensions().add(ext);
        }
    }

    private void findRenamedSteretoypes(Profile currentProfile, ElementTypeSetConfiguration previousTypes, DeltaStrategy.Diff result, ElementTypeConfigHelper helper) {
        for (ElementTypeConfiguration config : previousTypes.getElementTypeConfigurations()) {
            String originalName = helper.getStereotypeName(config);
            Stereotype currentStereotype = helper.getCurrentStereotype(config, currentProfile);
            if (currentStereotype == null) continue;
            String currentName = currentStereotype.getQualifiedName();
            if (originalName == null || currentName == null || originalName.equals(currentName)) continue;
            result.getRenamedStereotypes().put(originalName, currentStereotype);
        }
    }

    private void findAddedExtensions(ElementTypeSetConfiguration previousTypes, DeltaStrategy.Diff result, ElementTypeConfigHelper helper, Iterable<ImpliedExtension> allExtensions) {
        for (ImpliedExtension extension : allExtensions) {
            if (result.getAddedStereotypes().contains(extension.getStereotype()) || helper.exists(extension, previousTypes)) continue;
            result.getAddedExtensions().add(extension);
        }
    }
}

