/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.extensionPoint;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.papyrus.toolsmiths.profilemigration.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.IAtomicMigratorManager;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.IAtomicMigrator;

public class AtomicMigratorRegistry {
    public static final AtomicMigratorRegistry INSTANCE = new AtomicMigratorRegistry();
    private static final String EXTPT_ID = "org.eclipse.papyrus.toolsmiths.profilemigration.AtomicMigrators";
    private static final String ATOMIC_MIGRATOR_CLASS_PROPERTY = "class";
    private static final String ERASED_MIGRATOR_ELEMENT_NAME = "erasedMigrator";
    private static final String ERASED_MIGRATOR_CLASS_PROPERTY = "class";
    private List<Descriptor> registry = new ArrayList<Descriptor>();

    public AtomicMigratorRegistry() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            this.registry.add(new Descriptor(config));
            ++n2;
        }
    }

    public List<Descriptor> getRegistry() {
        return this.registry;
    }

    public class Descriptor {
        private IAtomicMigratorManager instance;
        private List<String> erasedMigrators = new ArrayList<String>();

        public Descriptor(IConfigurationElement config) {
            this.initInstance(config);
            this.initReplacements(config);
        }

        private IAtomicMigratorManager initInstance(IConfigurationElement config) {
            if (this.instance == null) {
                try {
                    this.instance = (IAtomicMigratorManager)config.createExecutableExtension("class");
                }
                catch (ClassCastException e) {
                    Activator.log.error("Atomic migrator does not implement IAtomicMigratorManager interface.", (Throwable)e);
                }
                catch (Exception e) {
                    Activator.log.error("Could not instantiate storage provider.", (Throwable)e);
                }
                if (this.instance == null) {
                    this.instance = new NullAtomicMigratorManager();
                }
            }
            return this.instance;
        }

        private void initReplacements(IConfigurationElement config) {
            IConfigurationElement[] test;
            IConfigurationElement[] iConfigurationElementArray = test = config.getChildren(AtomicMigratorRegistry.ERASED_MIGRATOR_ELEMENT_NAME);
            int n = test.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement replacementConfig = iConfigurationElementArray[n2];
                String className = replacementConfig.getAttribute("class");
                if (className != null) {
                    this.erasedMigrators.add(className);
                }
                ++n2;
            }
        }

        public IAtomicMigratorManager getInstance() {
            return this.instance;
        }

        public List<String> getErasedMigrators() {
            return this.erasedMigrators;
        }
    }

    public class NullAtomicMigratorManager
    implements IAtomicMigratorManager {
        @Override
        public IAtomicMigrator instantiate(TreeNode treeNode) {
            return null;
        }
    }
}

