/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.validation.internal;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.validation.IValidationMarkersService;
import org.eclipse.papyrus.views.validation.internal.ViewSettings;
import org.eclipse.papyrus.views.validation.internal.actions.CopyMarkerAction;
import org.eclipse.papyrus.views.validation.internal.actions.DeleteMarkerAction;
import org.eclipse.papyrus.views.validation.internal.actions.GotoMarkerAction;
import org.eclipse.papyrus.views.validation.internal.actions.SelectAllAction;
import org.eclipse.papyrus.views.validation.internal.providers.DescriptionLabelProvider;
import org.eclipse.papyrus.views.validation.internal.providers.ElementLabelProvider;
import org.eclipse.papyrus.views.validation.internal.providers.InvertedViewerComparator;
import org.eclipse.papyrus.views.validation.internal.providers.PathLabelProvider;
import org.eclipse.papyrus.views.validation.internal.providers.ProblemLabelProvider;
import org.eclipse.papyrus.views.validation.internal.providers.ProblemsContentProvider;
import org.eclipse.papyrus.views.validation.internal.providers.SeverityLabelProvider;
import org.eclipse.papyrus.views.validation.internal.providers.TypeLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.Page;

public class ModelValidationPage
extends Page {
    protected static final int COLUMN_WITH_MIN = 1;
    protected static final int COLUMN_WITH_MAX = 2000;
    protected static final int COLUMN_WITH_DEFAULT = 300;
    private final ViewSettings settings;
    private IValidationMarkersService markers;
    private LabelProviderService labelProviders;
    private ModelSet modelSet;
    private Control control;
    private TableViewer table;
    private GotoMarkerAction gotoMarkerAction;
    private CopyMarkerAction copyMarkerAction;
    private DeleteMarkerAction deleteMarkerAction;
    private SelectAllAction selectAllAction;
    ServicesRegistry services;
    private boolean ready;

    public ModelValidationPage(ServicesRegistry services, ViewSettings settings) throws ServiceException {
        this.settings = settings;
        this.services = services;
        this.markers = (IValidationMarkersService)ServiceUtils.getInstance().getService(IValidationMarkersService.class, (Object)services);
        this.labelProviders = (LabelProviderService)ServiceUtils.getInstance().getService(LabelProviderService.class, (Object)services);
        this.modelSet = ServiceUtils.getInstance().getModelSet((Object)services);
    }

    public void dispose() {
        this.markers = null;
        this.modelSet = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite tableParent = new Composite(parent, 0);
        this.control = tableParent;
        TableColumnLayout layout = new TableColumnLayout();
        tableParent.setLayout((Layout)layout);
        this.table = new TableViewer(tableParent, 68354);
        this.table.getTable().setHeaderVisible(true);
        this.table.getTable().setLinesVisible(true);
        this.table.setUseHashlookup(true);
        TableViewerColumn severity = new TableViewerColumn(this.table, 0);
        layout.setColumnData((Widget)severity.getColumn(), (ColumnLayoutData)new ColumnPixelData(24, false));
        severity.getColumn().setResizable(false);
        this.labels(severity, new SeverityLabelProvider());
        this.labels(this.column(this.table, "Description"), new DescriptionLabelProvider());
        this.labels(this.column(this.table, "Element"), new ElementLabelProvider(this.modelSet));
        this.labels(this.column(this.table, "Path"), new PathLabelProvider(this.labelProviders));
        this.labels(this.column(this.table, "Type"), new TypeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.table);
        this.table.setContentProvider((IContentProvider)new ProblemsContentProvider());
        this.table.setInput((Object)this.markers);
        this.table.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ModelValidationPage.this.gotoMarkerAction.isEnabled()) {
                    ModelValidationPage.this.gotoMarkerAction.run();
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.table);
        this.createActions();
        this.createContextMenu();
        this.table.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ModelValidationPage.this.updateColumnWidth(-1);
            }
        });
    }

    public void updateInput(ServicesRegistry newServices) {
        try {
            if (this.services != newServices) {
                this.services = newServices;
                this.markers = (IValidationMarkersService)ServiceUtils.getInstance().getService(IValidationMarkersService.class, (Object)this.services);
                this.table.setInput((Object)this.markers);
            }
        }
        catch (ServiceException e) {
            System.err.println((Object)e);
        }
    }

    private TableViewerColumn column(TableViewer table, String title) {
        TableViewerColumn result = new TableViewerColumn(table, 0);
        result.getColumn().setText(title);
        TableColumnLayout layout = (TableColumnLayout)table.getControl().getParent().getLayout();
        final int columnIndex = table.getTable().indexOf(result.getColumn());
        int width = this.settings.getColumnWidth(columnIndex);
        if (width < 1) {
            width = 300;
        } else if (width > 2000) {
            width = 2000;
        }
        ColumnPixelData layoutData = new ColumnPixelData(width, true);
        layout.setColumnData((Widget)result.getColumn(), (ColumnLayoutData)layoutData);
        result.getColumn().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ModelValidationPage.this.updateColumnWidth(columnIndex);
            }
        });
        return result;
    }

    private TableViewerColumn labels(final TableViewerColumn col, ProblemLabelProvider labelProvider) {
        final TableViewer viewer = (TableViewer)col.getViewer();
        final ViewerComparator sorter = labelProvider.createSorter();
        final int columnIndex = viewer.getTable().indexOf(col.getColumn());
        col.setLabelProvider(labelProvider.createCellLabelProvider());
        col.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerComparator current = viewer.getComparator();
                if (InvertedViewerComparator.unwrap(current) == sorter) {
                    ViewerComparator newSorter = InvertedViewerComparator.invert(current);
                    viewer.setComparator(newSorter);
                    int direction = InvertedViewerComparator.direction(newSorter);
                    viewer.getTable().setSortDirection(direction);
                    ModelValidationPage.this.settings.setSortDirection(direction);
                } else {
                    viewer.setComparator(sorter);
                    viewer.getTable().setSortColumn(col.getColumn());
                    viewer.getTable().setSortDirection(128);
                    ModelValidationPage.this.settings.setSortColumn(columnIndex);
                    ModelValidationPage.this.settings.setSortDirection(128);
                }
            }
        });
        if (this.settings.getSortColumn() == columnIndex) {
            int direction = this.settings.getSortDirection();
            viewer.setComparator(direction == 128 ? sorter : InvertedViewerComparator.invert(sorter));
            viewer.getTable().setSortColumn(col.getColumn());
            viewer.getTable().setSortDirection(direction);
        }
        return col;
    }

    private void createContextMenu() {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ModelValidationPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = contextMenu.createContextMenu(this.table.getControl());
        this.table.getControl().setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.papyrus.views.validation.ModelValidationView", contextMenu, (ISelectionProvider)this.table);
    }

    protected void createActions() {
        ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
        this.gotoMarkerAction = new GotoMarkerAction((IWorkbenchSite)this.getSite());
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.gotoMarkerAction);
        this.copyMarkerAction = new CopyMarkerAction((IWorkbenchSite)this.getSite());
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyMarkerAction);
        this.deleteMarkerAction = new DeleteMarkerAction((IWorkbenchSite)this.getSite());
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteMarkerAction);
        this.selectAllAction = new SelectAllAction((IWorkbenchSite)this.getSite());
        IActionBars actionBars = this.getSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyMarkerAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteMarkerAction);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this.gotoMarkerAction);
        menu.add((IAction)this.copyMarkerAction);
        menu.add((IAction)this.deleteMarkerAction);
        menu.add((IAction)this.selectAllAction);
        menu.add((IContributionItem)new Separator("additions"));
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
    }

    private void updateColumnWidth(int index) {
        if (index >= 0 != this.ready) {
            return;
        }
        if (index < 0) {
            this.ready = true;
            boolean startIndex = true;
            TableColumn[] columns = this.table.getTable().getColumns();
            Composite parent = this.table.getTable().getParent();
            TableColumnLayout layout = (TableColumnLayout)parent.getLayout();
            int i = 1;
            while (i < columns.length) {
                this.settings.setColumnWidth(i, columns[i].getWidth());
                ++i;
            }
            i = 1;
            while (i < columns.length) {
                layout.setColumnData((Widget)columns[i], (ColumnLayoutData)new ColumnPixelData(this.settings.getColumnWidth(i)));
                ++i;
            }
            parent.layout();
        } else {
            this.settings.setColumnWidth(index, this.table.getTable().getColumn(index).getWidth());
        }
    }
}

