/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.impl;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cbi.p2repo.aggregator.AggregatorFactory;
import org.eclipse.cbi.p2repo.aggregator.AggregatorPackage;
import org.eclipse.cbi.p2repo.aggregator.InfosProvider;
import org.eclipse.cbi.p2repo.aggregator.MavenItem;
import org.eclipse.cbi.p2repo.aggregator.MavenMapping;
import org.eclipse.cbi.p2repo.aggregator.Status;
import org.eclipse.cbi.p2repo.aggregator.StatusCode;
import org.eclipse.cbi.p2repo.util.StringUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.equinox.p2.metadata.Version;

public class MavenMappingImpl
extends MinimalEObjectImpl.Container
implements MavenMapping {
    public static final String MAVEN_SOURCES_CLASSIFIER = "sources";
    private static final Pattern P2_SOURCE_BUNDLE_OR_FEATURE = Pattern.compile("(.*)(?:\\.source)(|\\.feature\\.group)");
    private Pattern compiledPattern;
    private Pattern compiledVersionPattern;
    protected int eFlags = 0;
    protected EList<String> errors;
    protected EList<String> warnings;
    protected EList<String> infos;
    protected static final String NAME_PATTERN_EDEFAULT = null;
    protected String namePattern = NAME_PATTERN_EDEFAULT;
    protected static final String GROUP_ID_EDEFAULT = null;
    protected String groupId = GROUP_ID_EDEFAULT;
    protected static final String ARTIFACT_ID_EDEFAULT = null;
    protected String artifactId = ARTIFACT_ID_EDEFAULT;
    protected static final String VERSION_PATTERN_EDEFAULT = null;
    protected String versionPattern = VERSION_PATTERN_EDEFAULT;
    protected static final String VERSION_TEMPLATE_EDEFAULT = null;
    protected String versionTemplate = VERSION_TEMPLATE_EDEFAULT;
    protected static final boolean SNAPSHOT_EDEFAULT = false;
    protected static final int SNAPSHOT_EFLAG = 1;
    protected static final int SNAPSHOT_ESETFLAG = 2;

    protected MavenMappingImpl() {
    }

    public MavenMappingImpl(String namePattern, String groupId, String artifactId) {
        this.setNamePattern(namePattern);
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
    }

    static void checkReplacements(Pattern pattern, String ... replacements) {
        String emptyString = "";
        String auxGroup = "(.*)";
        Matcher matcher = pattern.matcher(emptyString);
        StringBuilder auxPatternBuilder = new StringBuilder();
        int i = matcher.groupCount();
        while (i > 0) {
            auxPatternBuilder.append(auxGroup);
            --i;
        }
        Pattern auxPattern = Pattern.compile(auxPatternBuilder.toString());
        Matcher auxMatcher = auxPattern.matcher(emptyString);
        String[] stringArray = replacements;
        int n = replacements.length;
        int n2 = 0;
        while (n2 < n) {
            String replacement = stringArray[n2];
            auxMatcher.replaceAll(replacement);
            ++n2;
        }
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == InfosProvider.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == InfosProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getStatus();
            }
            case 1: {
                return this.getErrors();
            }
            case 2: {
                return this.getWarnings();
            }
            case 3: {
                return this.getInfos();
            }
            case 4: {
                return this.getNamePattern();
            }
            case 5: {
                return this.getGroupId();
            }
            case 6: {
                return this.getArtifactId();
            }
            case 7: {
                return this.getVersionPattern();
            }
            case 8: {
                return this.getVersionTemplate();
            }
            case 9: {
                return this.isSnapshot();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getStatus() != null;
            }
            case 1: {
                return this.errors != null && !this.errors.isEmpty();
            }
            case 2: {
                return this.warnings != null && !this.warnings.isEmpty();
            }
            case 3: {
                return this.infos != null && !this.infos.isEmpty();
            }
            case 4: {
                return NAME_PATTERN_EDEFAULT == null ? this.namePattern != null : !NAME_PATTERN_EDEFAULT.equals(this.namePattern);
            }
            case 5: {
                return GROUP_ID_EDEFAULT == null ? this.groupId != null : !GROUP_ID_EDEFAULT.equals(this.groupId);
            }
            case 6: {
                return ARTIFACT_ID_EDEFAULT == null ? this.artifactId != null : !ARTIFACT_ID_EDEFAULT.equals(this.artifactId);
            }
            case 7: {
                return VERSION_PATTERN_EDEFAULT == null ? this.versionPattern != null : !VERSION_PATTERN_EDEFAULT.equals(this.versionPattern);
            }
            case 8: {
                return VERSION_TEMPLATE_EDEFAULT == null ? this.versionTemplate != null : !VERSION_TEMPLATE_EDEFAULT.equals(this.versionTemplate);
            }
            case 9: {
                return this.isSetSnapshot();
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getErrors().clear();
                this.getErrors().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getWarnings().clear();
                this.getWarnings().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getInfos().clear();
                this.getInfos().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setNamePattern((String)newValue);
                return;
            }
            case 5: {
                this.setGroupId((String)newValue);
                return;
            }
            case 6: {
                this.setArtifactId((String)newValue);
                return;
            }
            case 7: {
                this.setVersionPattern((String)newValue);
                return;
            }
            case 8: {
                this.setVersionTemplate((String)newValue);
                return;
            }
            case 9: {
                this.setSnapshot((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.MAVEN_MAPPING;
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getErrors().clear();
                return;
            }
            case 2: {
                this.getWarnings().clear();
                return;
            }
            case 3: {
                this.getInfos().clear();
                return;
            }
            case 4: {
                this.setNamePattern(NAME_PATTERN_EDEFAULT);
                return;
            }
            case 5: {
                this.setGroupId(GROUP_ID_EDEFAULT);
                return;
            }
            case 6: {
                this.setArtifactId(ARTIFACT_ID_EDEFAULT);
                return;
            }
            case 7: {
                this.setVersionPattern(VERSION_PATTERN_EDEFAULT);
                return;
            }
            case 8: {
                this.setVersionTemplate(VERSION_TEMPLATE_EDEFAULT);
                return;
            }
            case 9: {
                this.unsetSnapshot();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public EList<String> getErrors() {
        if (this.errors == null) {
            this.errors = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 1);
        }
        return this.errors;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public EList<String> getInfos() {
        if (this.infos == null) {
            this.infos = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 3);
        }
        return this.infos;
    }

    @Override
    public String getNamePattern() {
        return this.namePattern;
    }

    @Override
    public Status getStatus() {
        try {
            String pattern = StringUtils.trimmedOrNull((String)this.getNamePattern());
            if (pattern == null || StringUtils.trimmedOrNull((String)this.getGroupId()) == null || StringUtils.trimmedOrNull((String)this.getArtifactId()) == null) {
                return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, "Incomplete");
            }
            this.compiledPattern = Pattern.compile(pattern);
            MavenMappingImpl.checkReplacements(this.compiledPattern, this.getGroupId(), this.getArtifactId());
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
        }
        catch (PatternSyntaxException e) {
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, e.getMessage());
        }
    }

    @Override
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Override
    public String getVersionTemplate() {
        return this.versionTemplate;
    }

    @Override
    public EList<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 2);
        }
        return this.warnings;
    }

    @Override
    public MavenItem map(String installableUnitID, Version version) {
        if (this.compiledPattern != null) {
            Matcher m;
            Matcher matcher = P2_SOURCE_BUNDLE_OR_FEATURE.matcher(installableUnitID);
            boolean isSource = matcher.matches();
            if (isSource) {
                installableUnitID = String.valueOf(matcher.group(1)) + matcher.group(2);
            }
            if ((m = this.compiledPattern.matcher(installableUnitID)).matches()) {
                String mappedVersion;
                MavenItem item = AggregatorFactory.eINSTANCE.createMavenItem();
                item.setGroupId(m.replaceFirst(this.getGroupId()));
                item.setArtifactId(m.replaceFirst(this.getArtifactId()));
                item.setMavenMapping(this);
                if (isSource) {
                    item.setClassifier(MAVEN_SOURCES_CLASSIFIER);
                }
                if ((mappedVersion = this.mapVersion(version)) != null) {
                    item.setMappedVersion(mappedVersion);
                }
                return item;
            }
        }
        return null;
    }

    @Override
    public String mapVersion(Version version) {
        if (version != null && this.versionPattern != null && this.versionTemplate != null) {
            String original;
            Matcher vm;
            if (this.compiledVersionPattern == null) {
                this.compiledVersionPattern = Pattern.compile(this.versionPattern);
            }
            if ((vm = this.compiledVersionPattern.matcher((original = version.getOriginal()) == null ? version.toString() : original)).matches()) {
                return vm.replaceFirst(this.versionTemplate);
            }
        }
        return null;
    }

    @Override
    public void setArtifactId(String newArtifactId) {
        String oldArtifactId = this.artifactId;
        this.artifactId = newArtifactId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldArtifactId, (Object)this.artifactId));
        }
    }

    @Override
    public void setGroupId(String newGroupId) {
        String oldGroupId = this.groupId;
        this.groupId = newGroupId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldGroupId, (Object)this.groupId));
        }
    }

    @Override
    public void setNamePattern(String newNamePattern) {
        String oldNamePattern = this.namePattern;
        this.namePattern = newNamePattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldNamePattern, (Object)this.namePattern));
        }
        if (newNamePattern != null) {
            if (!newNamePattern.equals(oldNamePattern)) {
                try {
                    this.compiledPattern = Pattern.compile(StringUtils.trimmedOrNull((String)newNamePattern));
                }
                catch (PatternSyntaxException patternSyntaxException) {}
            }
        } else {
            this.compiledPattern = null;
        }
    }

    @Override
    public void setVersionPattern(String newVersionPattern) {
        String oldVersionPattern = this.versionPattern;
        this.versionPattern = newVersionPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldVersionPattern, (Object)this.versionPattern));
        }
    }

    @Override
    public void setVersionTemplate(String newVersionTemplate) {
        String oldVersionTemplate = this.versionTemplate;
        this.versionTemplate = newVersionTemplate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldVersionTemplate, (Object)this.versionTemplate));
        }
    }

    @Override
    public boolean isSnapshot() {
        return (this.eFlags & 1) != 0;
    }

    @Override
    public void setSnapshot(boolean newSnapshot) {
        boolean oldSnapshot;
        boolean bl = oldSnapshot = (this.eFlags & 1) != 0;
        this.eFlags = newSnapshot ? (this.eFlags |= 1) : (this.eFlags &= 0xFFFFFFFE);
        boolean oldSnapshotESet = (this.eFlags & 2) != 0;
        this.eFlags |= 2;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldSnapshot, newSnapshot, !oldSnapshotESet));
        }
    }

    @Override
    public void unsetSnapshot() {
        boolean oldSnapshot = (this.eFlags & 1) != 0;
        boolean oldSnapshotESet = (this.eFlags & 2) != 0;
        this.eFlags &= 0xFFFFFFFE;
        this.eFlags &= 0xFFFFFFFD;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 9, oldSnapshot, false, oldSnapshotESet));
        }
    }

    @Override
    public boolean isSetSnapshot() {
        return (this.eFlags & 2) != 0;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (errors: ");
        result.append(this.errors);
        result.append(", warnings: ");
        result.append(this.warnings);
        result.append(", infos: ");
        result.append(this.infos);
        result.append(", namePattern: ");
        result.append(this.namePattern);
        result.append(", groupId: ");
        result.append(this.groupId);
        result.append(", artifactId: ");
        result.append(this.artifactId);
        result.append(", versionPattern: ");
        result.append(this.versionPattern);
        result.append(", versionTemplate: ");
        result.append(this.versionTemplate);
        result.append(", snapshot: ");
        if ((this.eFlags & 2) != 0) {
            result.append((this.eFlags & 1) != 0);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }
}

