/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.api;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class TableEditorDeleteHelper {
    private Table table;
    private IElementEditService commandProvider;
    private Command deleteCommand;
    private TransactionalEditingDomain editingDomain;

    public TableEditorDeleteHelper(Table table) {
        this.table = table;
    }

    public IStatus canDeleteTableEditor() {
        ServicesRegistry servicesRegistry;
        String pluginID = this.getPluginID();
        if (this.table == null) {
            return new Status(0, pluginID, 0, "There is no table to delete", null);
        }
        if (EMFHelper.isReadOnly((EObject)this.table)) {
            return new Status(4, pluginID, 14, "The table to delete is read-only", null);
        }
        this.commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)this.table);
        if (this.commandProvider == null) {
            return new Status(4, pluginID, 15, "There is no command provider to delete the table", null);
        }
        DestroyElementRequest request = new DestroyElementRequest((EObject)this.table, false);
        try {
            servicesRegistry = ServiceUtilsForResource.getInstance().getServiceRegistry(this.table.getContext().eResource());
        }
        catch (ServiceException e) {
            return new Status(4, pluginID, 1, e.getMessage(), (Throwable)e);
        }
        if (servicesRegistry == null) {
            return new Status(4, pluginID, 1, "Service Registry not found", null);
        }
        try {
            this.editingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)servicesRegistry);
        }
        catch (ServiceException e) {
            return new Status(4, pluginID, 3, e.getMessage(), (Throwable)e);
        }
        if (this.editingDomain == null) {
            return new Status(4, pluginID, 3, "The editing domain has not been found", null);
        }
        ICommand cmd = this.commandProvider.getEditCommand((IEditCommandRequest)request);
        if (cmd == null) {
            return new Status(4, pluginID, 12, "The deletion command cannot be created", null);
        }
        if (!cmd.canExecute()) {
            return new Status(4, pluginID, 13, "The deletion command is not executable", null);
        }
        this.deleteCommand = new GMFtoEMFCommandWrapper(cmd);
        return Status.OK_STATUS;
    }

    public Command getDeleteTableEditorCommand() {
        if (this.canDeleteTableEditor().isOK()) {
            return this.deleteCommand;
        }
        return null;
    }

    public void deleteTableEditor() {
        Command cmd = this.getDeleteTableEditorCommand();
        if (cmd != null) {
            this.editingDomain.getCommandStack().execute(cmd);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    protected String getPluginID() {
        return "org.eclipse.papyrus.infra.nattable.common";
    }
}

