/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.representation.architecture;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.textedit.representation.TextDocumentRepresentation;
import org.eclipse.papyrus.infra.textedit.representation.architecture.Activator;
import org.eclipse.papyrus.infra.textedit.representation.architecture.commands.CreateTextDocumentViewCommand;
import org.eclipse.papyrus.infra.textedit.representation.architecture.internal.messages.Messages;
import org.eclipse.papyrus.infra.textedit.representation.command.ICreateTextDocumentEditorCommand;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractCreateTextDocumentEditorCommand
implements ICreateTextDocumentEditorCommand {
    protected String askTextDocumentEditorName(String dialogTitle, String proposedName) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), dialogTitle, Messages.AbstractCreateTextDocumentEditorCommand_EnterTheNameForTheNewTextDocument, proposedName, null);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    protected TextDocument execute(TextDocumentRepresentation textDocumentRepresentation, String textDocumentEditorName, EObject semanticContext, boolean openAfterCreation) {
        return this.execute(textDocumentRepresentation, textDocumentEditorName, semanticContext, semanticContext, openAfterCreation);
    }

    protected TextDocument execute(TextDocumentRepresentation textDocumentRepresentation, String textDocumentName, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation) {
        Resource res = semanticContext.eResource();
        URI semanticURI = res.getURI();
        if (semanticURI.isPlatformPlugin()) {
            Activator.log.error((Throwable)new UnsupportedOperationException("TextDocument for element stored as platform plugin is not yet supported"));
            return null;
        }
        TransactionalEditingDomain domain = this.getEditingDomain(semanticContext);
        if (domain == null) {
            return null;
        }
        CreateTextDocumentViewCommand command = this.createTextDocumentEditorCreationCommand(domain, textDocumentRepresentation, textDocumentName, semanticContext, graphicalContext, openAfterCreation);
        domain.getCommandStack().execute((Command)command);
        return (TextDocument)command.getCreatedEditorView();
    }

    public CreateTextDocumentViewCommand createTextDocumentEditorCreationCommand(TransactionalEditingDomain editingDomain, TextDocumentRepresentation textDocumentRepresentation, String textDocumentEditorName, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation) {
        return new CreateTextDocumentViewCommand(editingDomain, textDocumentRepresentation, textDocumentEditorName, semanticContext, graphicalContext, openAfterCreation);
    }

    public CreateTextDocumentViewCommand createTextDocumentEditorCreationCommand(TransactionalEditingDomain editingDomain, TextDocumentRepresentation textDocumentRepresentation, String textDocumentEditorName, EObject semanticContext, boolean openAfterCreation) {
        return new CreateTextDocumentViewCommand(editingDomain, textDocumentRepresentation, textDocumentEditorName, semanticContext, openAfterCreation);
    }

    protected final ServicesRegistry getServiceRegistry(EObject modelElement) {
        try {
            return ServiceUtilsForEObject.getInstance().getServiceRegistry(modelElement);
        }
        catch (ServiceException e) {
            Activator.log.error("ServicesRegistry not found", (Throwable)e);
            return null;
        }
    }

    protected final TransactionalEditingDomain getEditingDomain(EObject modelElement) {
        ServicesRegistry servicesRegistry = this.getServiceRegistry(modelElement);
        if (servicesRegistry == null) {
            return null;
        }
        try {
            return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("EditingDomain not found", (Throwable)e);
            return null;
        }
    }
}

