/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.releng.tools.internal.popup.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cbi.targetplatform.model.Location;
import org.eclipse.cbi.targetplatform.model.TargetPlatform;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.releng.tools.internal.popup.actions.DependencyUpdater;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class TPDUpdater
extends DependencyUpdater<Location> {
    private Resource currentTarget;

    @Override
    public boolean canUpdate(IFile file) {
        return "tpd".equals(file.getFileExtension());
    }

    @Override
    protected List<Location> getNodesToUpdate(IFile file) throws CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI workspaceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        this.currentTarget = resourceSet.getResource(workspaceURI, true);
        for (EObject rootElement : this.currentTarget.getContents()) {
            if (!(rootElement instanceof TargetPlatform)) continue;
            TargetPlatform tp = (TargetPlatform)rootElement;
            return tp.getLocations();
        }
        return Collections.emptyList();
    }

    @Override
    protected void save(IFile file) throws Exception {
        this.currentTarget.save(null);
    }

    @Override
    protected String getCurrentLocation(Location uri) {
        return uri.getUri();
    }

    @Override
    protected void updateUri(Location uri, String location) {
        uri.setUri(location);
    }

    @Override
    protected String getComment(Location location) {
        List<String> comments = this.findCommentsAsString(location);
        for (String comment : comments) {
            if (!comment.contains("updateFrom")) continue;
            return comment;
        }
        return null;
    }

    protected List<String> findCommentsAsString(Location location) {
        ArrayList<String> comments = new ArrayList<String>();
        ICompositeNode grammarNode = NodeModelUtils.getNode((EObject)location);
        if (grammarNode instanceof ICompositeNode) {
            ICompositeNode compositeNode = grammarNode;
            for (INode child : compositeNode.getChildren()) {
                TerminalRule rule;
                String name;
                ILeafNode leafNode;
                if (!(child instanceof ILeafNode) || !(leafNode = (ILeafNode)child).isHidden() || !(child.getGrammarElement() instanceof TerminalRule) || !"SL_COMMENT".equals(name = (rule = (TerminalRule)child.getGrammarElement()).getName()) && !"ML_COMMENT".equals(name)) continue;
                String text = leafNode.getText();
                text = text.replaceAll("[\\*/]", "").trim();
                comments.add(text);
            }
        }
        return comments;
    }
}

