/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.handler;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.internal.validation.ProfileSwitchValidator;
import org.eclipse.papyrus.uml.modelrepair.ui.SwitchProfileDialog;
import org.eclipse.papyrus.uml.modelrepair.validation.ProfileSwitchContext;
import org.eclipse.papyrus.uml.tools.util.ProfileHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Package;

public class SwitchProfileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection.isEmpty() || !(currentSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        EObject selectedAdapter = EMFHelper.getEObject((Object)selection.getFirstElement());
        final Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (selectedAdapter instanceof Package) {
            final Package selectedPackage = (Package)selectedAdapter;
            Job openDialogJob = new Job("Switch profiles"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Analyzing model...", -1);
                    try {
                        ModelSet modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)selectedPackage);
                        TransactionalEditingDomain editingDomain = modelSet.getTransactionalEditingDomain();
                        SwitchProfileHandler.this.switchProfilesForModelSet(selectedPackage, modelSet, editingDomain, activeShell);
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                        return new Status(4, "org.eclipse.papyrus.uml.modelrepair", e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            openDialogJob.setUser(true);
            openDialogJob.schedule();
        }
        return null;
    }

    public void switchProfilesForModelSet(Package profiledPackage, final ModelSet modelSet, final TransactionalEditingDomain editingDomain, final Shell activeShell) {
        EcoreUtil.resolveAll((ResourceSet)modelSet);
        final Collection allAppliedProfiles = ProfileHelper.getAllAppliedProfiles((ModelSet)modelSet);
        ProfileSwitchValidator validator = new ProfileSwitchValidator();
        if (validator.validate(new ProfileSwitchContext(activeShell, modelSet, editingDomain, profiledPackage, allAppliedProfiles))) {
            activeShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (allAppliedProfiles.isEmpty()) {
                        MessageDialog.openInformation((Shell)activeShell, (String)"Switch Profiles", (String)"The selected model has no profiles applied.");
                        return;
                    }
                    try {
                        SwitchProfileDialog dialog = new SwitchProfileDialog(activeShell, modelSet, editingDomain);
                        dialog.open();
                    }
                    catch (ServiceException e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.uml.modelrepair", "Failed to open profile switching dialog.", (Throwable)e), 2);
                    }
                }
            });
        }
    }
}

