/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.geometry;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

public class Segment {
    private final PrecisionPoint start;
    private final PrecisionPoint end;

    public Segment(PrecisionPoint start, PrecisionPoint end) {
        this.start = start.getPreciseCopy();
        this.end = end.getPreciseCopy();
    }

    public Segment(Point start, Point end) {
        this.start = new PrecisionPoint(start);
        this.end = new PrecisionPoint(end);
    }

    public boolean hasIntersection(Segment segment) {
        return this.getIntersection(segment) != null;
    }

    public final PrecisionPoint getStartPoint() {
        return this.start;
    }

    public final PrecisionPoint getEndPoint() {
        return this.end;
    }

    public PrecisionPoint getIntersection(Segment segment) {
        double s1_x = segment.getEndPoint().preciseX() - segment.getStartPoint().preciseX();
        double s1_y = segment.getEndPoint().preciseY() - segment.getStartPoint().preciseY();
        double s2_x = this.getEndPoint().preciseX() - this.getStartPoint().preciseX();
        double s2_y = this.getEndPoint().preciseY() - this.getStartPoint().preciseY();
        double s = (-s1_y * (segment.getStartPoint().preciseX() - this.getStartPoint().preciseX()) + s1_x * (segment.getStartPoint().preciseY() - this.getStartPoint().preciseY())) / (-s2_x * s1_y + s1_x * s2_y);
        double t = (s2_x * (segment.getStartPoint().preciseY() - this.getStartPoint().preciseY()) - s2_y * (segment.getStartPoint().preciseX() - this.getStartPoint().preciseX())) / (-s2_x * s1_y + s1_x * s2_y);
        PrecisionPoint result = null;
        if (s >= 0.0 && s <= 1.0 && t >= 0.0 && t <= 1.0) {
            result = new PrecisionPoint((int)(segment.getStartPoint().preciseX() + t * s1_x), (int)(segment.getStartPoint().preciseY() + t * s1_y));
        }
        return result;
    }
}

