/**
 * Copyright (c) 2006, 2009, 2013 , 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package impl.diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;
import xpt.QualifiedClassNameProvider;

/**
 * Revisit: [MG]: @Inject extension same-named-api-class -> template extends api-class?
 */
@Singleton
@SuppressWarnings("all")
public class ChildNodeLabelEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private QualifiedClassNameProvider _qualifiedClassNameProvider;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  @Extension
  private xpt.diagram.editparts.Common _common_1;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  public CharSequence className(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }
  
  public CharSequence constructor(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDragTrackerBody(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (request instanceof org.eclipse.gef.requests.SelectionRequest && ((org.eclipse.gef.requests.SelectionRequest) request).getLastButtonPressed() == 3) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("return new org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx(this);");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createDefaultEditPoliciesBody(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.SEMANTIC_ROLE, new ");
    CharSequence _itemSemanticEditPolicyQualifiedClassName = this._qualifiedClassNameProvider.getItemSemanticEditPolicyQualifiedClassName(it);
    _builder.append(_itemSemanticEditPolicyQualifiedClassName);
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, new org.eclipse.papyrus.uml.diagram.common.editpolicies.UMLTextNonResizableEditPolicy());");
    _builder.newLine();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.COMPONENT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ListItemComponentEditPolicy());");
    _builder.newLine();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.DIRECT_EDIT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy());");
    _builder.newLine();
    CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
    _builder.append(_behaviour);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence handleNotificationEventBody(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.append("Object feature = event.getFeature();");
    _builder.newLine();
    CharSequence _handleText = this._common_1.handleText(it);
    _builder.append(_handleText);
    _builder.newLineIfNotEmpty();
    {
      boolean _isLabelElementIcon = it.isLabelElementIcon();
      if (_isLabelElementIcon) {
        _builder.append("if(event.getNewValue() instanceof org.eclipse.emf.ecore.EAnnotation && org.eclipse.papyrus.infra.emf.appearance.helper.VisualInformationPapyrusConstants.DISPLAY_NAMELABELICON.equals(((org.eclipse.emf.ecore.EAnnotation)event.getNewValue()).getSource())){\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("refreshLabel();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("if (org.eclipse.uml2.uml.UMLPackage.eINSTANCE.getFeature_IsStatic().equals(feature)) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("refreshUnderline();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("super.handleNotificationEvent(event);");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isSelectable(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isSelectable() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getFigure().isShowing();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
