/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.filters.internal.operations;

import com.google.common.base.Strings;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.filters.internal.UMLFiltersPlugin;
import org.eclipse.papyrus.uml.filters.ProfileApplied;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ProfileAppliedOperations {
    protected ProfileAppliedOperations() {
    }

    public static boolean matches(ProfileApplied profileApplied, Object input) {
        boolean result = false;
        if (!Strings.isNullOrEmpty((String)profileApplied.getProfileQualifiedName())) {
            if (!(input instanceof EObject) && input instanceof IAdaptable) {
                input = ((IAdaptable)input).getAdapter(EObject.class);
            }
            if (input instanceof Element) {
                Package package_ = ((Element)input).getNearestPackage();
                ResourceSet context = package_.eResource().getResourceSet();
                if (package_ != null) {
                    String qualifiedName = Strings.emptyToNull((String)profileApplied.getProfileQualifiedName());
                    URI profileURI = URI.createURI((String)profileApplied.getProfileURI(), (boolean)true);
                    for (Profile next : package_.getAllAppliedProfiles()) {
                        if (ProfileAppliedOperations.prematch(qualifiedName, next) && (result = ProfileAppliedOperations.match(profileURI, next, context))) break;
                    }
                }
            }
        }
        return result;
    }

    protected static boolean prematch(String qualifiedName, Profile profile) {
        boolean result = true;
        if (qualifiedName != null && !profile.eIsProxy()) {
            result = qualifiedName.equals(profile.getQualifiedName());
        }
        return result;
    }

    protected static boolean match(URI expectedURI, Profile profile, ResourceSet context) {
        URIConverter converter = context.getURIConverter();
        expectedURI = converter.normalize(expectedURI);
        URI profileURI = converter.normalize(EcoreUtil.getURI((EObject)profile));
        return expectedURI.equals(profileURI);
    }

    public static Profile resolveProfile(ProfileApplied profileApplied, Object context) {
        Profile result = null;
        if (!(context instanceof EObject) && context instanceof IAdaptable) {
            context = ((IAdaptable)context).getAdapter(EObject.class);
        }
        if (profileApplied.getProfileURI() != null && context instanceof EObject) {
            ResourceSet rset;
            Resource resource = ((EObject)context).eResource();
            ResourceSet resourceSet = rset = resource == null ? null : resource.getResourceSet();
            if (rset != null) {
                try {
                    URI uri = URI.createURI((String)profileApplied.getProfileURI(), (boolean)true);
                    EObject resolved = rset.getEObject(uri, true);
                    if (resolved instanceof Profile) {
                        result = (Profile)resolved;
                    }
                }
                catch (Exception e) {
                    UMLFiltersPlugin.INSTANCE.log(e);
                }
            }
        }
        return result;
    }
}

