/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.property.xtext.ui.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.uml.textedit.property.xtext.scoping.UmlPropertyScopeProvider;
import org.eclipse.papyrus.uml.textedit.property.xtext.ui.contentassist.AbstractUmlPropertyProposalProvider;
import org.eclipse.papyrus.uml.textedit.property.xtext.ui.contributions.UMLPropertyEditorPropertyUtil;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.ModifierSpecification;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.ModifiersRule;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.MultiplicityRule;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.PropertyRule;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.QualifiedName;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.TypeRule;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.xtext.integration.CompletionProposalUtils;
import org.eclipse.papyrus.uml.xtext.integration.CustomCompletionProposal;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class UmlPropertyProposalProvider
extends AbstractUmlPropertyProposalProvider {
    @Override
    public void completePropertyRule_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ArrayList<Classifier> allClassifiers = new ArrayList<Classifier>();
        Namespace namespace = (Namespace)EcoreUtil.getRootContainer((EObject)ContextElementUtil.getContextElement((Resource)model.eResource()));
        allClassifiers.addAll(this.getRecursivelyOwnedClassifiers(namespace));
        allClassifiers.addAll(this.getRecursivelyImportedClassifiers(namespace));
        for (Classifier c : allClassifiers) {
            if (!c.getQualifiedName().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            String displayString = c.getQualifiedName();
            String completionString = CompletionProposalUtils.getQualifiedNameLabelWithSufficientDepth((NamedElement)c, (Namespace)namespace);
            CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)c, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeTypeRule_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Namespace root = (Namespace)EcoreUtil.getRootContainer((EObject)ContextElementUtil.getContextElement((Resource)model.eResource()));
        if (root == null) {
            return;
        }
        String completionString = String.valueOf(root.getName()) + "::";
        String displayString = String.valueOf(root.getName()) + "::";
        CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)root, (String)completionString, (String)displayString, (ContentAssistContext)context);
        acceptor.accept((ICompletionProposal)completionProposal);
        List topLevelPackages = PackageUtil.getTopLevelPackages((Element)root);
        for (Package p : topLevelPackages) {
            if (!p.getName().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            completionString = String.valueOf(p.getName()) + "::";
            displayString = String.valueOf(p.getName()) + "::";
            completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)root, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeTypeRule_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Namespace namespace = ((Property)ContextElementUtil.getContextElement((Resource)model.eResource())).getNamespace();
        if (model instanceof TypeRule) {
            TypeRule typeRule = (TypeRule)model;
            QualifiedName path = typeRule.getPath();
            while (path.getRemaining() != null) {
                path = path.getRemaining();
            }
            namespace = path.getPath();
        } else if (!(model instanceof PropertyRule)) {
            return;
        }
        for (NamedElement n : namespace.getOwnedMembers()) {
            if (!(n instanceof Classifier) || !n.getName().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            String completionString = n.getName();
            String displayString = n.getName();
            CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)n, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeQualifiedName_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeQualifiedName_Remaining(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CustomCompletionProposal completionProposal;
        String displayString;
        String completionString;
        QualifiedName path = (QualifiedName)model;
        for (NamedElement n : path.getPath().getOwnedMembers()) {
            if (!(n instanceof Package) || !n.getName().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            completionString = String.valueOf(n.getName()) + "::";
            displayString = String.valueOf(n.getName()) + "::";
            completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)n, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
        for (Package p : path.getPath().getImportedPackages()) {
            if (!p.getName().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            completionString = String.valueOf(p.getName()) + "::";
            displayString = String.valueOf(p.getName()) + "::";
            completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)p, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeRedefinesRule_Property(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (Property inherited : UmlPropertyScopeProvider.retrieveInheritedProperties((EObject)model)) {
            if (!inherited.getName().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            String completionString = inherited.getName();
            String displayString = UMLPropertyEditorPropertyUtil.getLabel(inherited);
            CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)inherited, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeSubsetsRule_Property(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (Property inherited : UmlPropertyScopeProvider.retrieveInheritedProperties((EObject)model)) {
            if (!inherited.getName().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            String completionString = inherited.getName();
            String displayString = UMLPropertyEditorPropertyUtil.getLabel(inherited);
            CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)inherited, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        EObject model = contentAssistContext.getCurrentModel();
        if (!(model instanceof ModifiersRule)) {
            super.completeKeyword(keyword, contentAssistContext, acceptor);
            return;
        }
        ModifiersRule modifiersRule = (ModifiersRule)model;
        boolean isOrdered = false;
        boolean isReadOnly = true;
        boolean isUnion = false;
        boolean isUnique = false;
        for (ModifierSpecification spec : modifiersRule.getValues()) {
            if (spec.getValue() == null) continue;
            switch (spec.getValue()) {
                case ORDERED: {
                    isOrdered = true;
                    break;
                }
                case READ_ONLY: {
                    isReadOnly = !isReadOnly;
                    break;
                }
                case UNION: {
                    isUnion = true;
                    break;
                }
                case UNIQUE: {
                    isUnique = true;
                    break;
                }
            }
        }
        String value = keyword.getValue();
        if (value.equals("ordered")) {
            if (!isOrdered) {
                super.completeKeyword(keyword, contentAssistContext, acceptor);
            }
        } else if (value.equals("readOnly")) {
            if (!isReadOnly) {
                super.completeKeyword(keyword, contentAssistContext, acceptor);
            }
        } else if (value.equals("unique")) {
            if (!isUnique) {
                super.completeKeyword(keyword, contentAssistContext, acceptor);
            }
        } else if (value.equals("union")) {
            if (!isUnion) {
                super.completeKeyword(keyword, contentAssistContext, acceptor);
            }
        } else {
            super.completeKeyword(keyword, contentAssistContext, acceptor);
        }
    }

    @Override
    public void complete_MultiplicityRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String zero_one = "[0..1]";
        String one = "[1]";
        String one_star = "[1..*]";
        String star = "[*]";
        String completionString = "";
        String displayString = "";
        CustomCompletionProposal completionProposal = null;
        completionString = zero_one.substring(context.getPrefix().length());
        displayString = zero_one;
        completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
        acceptor.accept((ICompletionProposal)completionProposal);
        completionString = one.substring(context.getPrefix().length());
        displayString = one;
        completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
        acceptor.accept((ICompletionProposal)completionProposal);
        completionString = one_star.substring(context.getPrefix().length());
        displayString = one_star + "     ";
        completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
        acceptor.accept((ICompletionProposal)completionProposal);
        completionString = star.substring(context.getPrefix().length());
        displayString = star;
        completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
        acceptor.accept((ICompletionProposal)completionProposal);
    }

    @Override
    public void completeMultiplicityRule_Bounds(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block4: {
            if (!(model instanceof MultiplicityRule)) {
                return;
            }
            MultiplicityRule multiplicityRule = (MultiplicityRule)model;
            if (multiplicityRule.getBounds().size() == 2) {
                String value = ((BoundSpecification)multiplicityRule.getBounds().get(1)).getValue();
                try {
                    Integer.valueOf(value);
                }
                catch (Exception e) {
                    if (((BoundSpecification)multiplicityRule.getBounds().get(0)).getValue().equals("*") || ((BoundSpecification)multiplicityRule.getBounds().get(1)).getValue().equals("*")) break block4;
                    String completionString = "*";
                    String displayString = "*";
                    CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                    acceptor.accept((ICompletionProposal)completionProposal);
                }
            }
        }
    }

    private List<Classifier> getRecursivelyOwnedClassifiers(Namespace context) {
        ArrayList<Classifier> recursivelyOwnedClassifiers = new ArrayList<Classifier>();
        EList allOwnedElements = context.getOwnedElements();
        for (Element e : allOwnedElements) {
            if (e instanceof Classifier) {
                recursivelyOwnedClassifiers.add((Classifier)e);
            }
            if (!(e instanceof Namespace)) continue;
            recursivelyOwnedClassifiers.addAll(this.getRecursivelyOwnedClassifiers((Namespace)e));
        }
        return recursivelyOwnedClassifiers;
    }

    private List<Classifier> getRecursivelyImportedClassifiers(Namespace context) {
        ArrayList<Classifier> recursivelyImportedClassifiers = new ArrayList<Classifier>();
        EList importedPackages = context.getImportedPackages();
        for (Package p : importedPackages) {
            recursivelyImportedClassifiers.addAll(this.getRecursivelyOwnedClassifiers((Namespace)p));
        }
        return recursivelyImportedClassifiers;
    }
}

