/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.template;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.widgets.providers.UnsetObject;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateCheckStateProvider;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateDescription;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateTransfoProvider;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplatesContentProvider;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplatesLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SelectModelTemplateComposite
extends Composite {
    private CheckboxTableViewer templateTableViewer;
    private ComboViewer singleTemplateCombo;
    private ModelTemplateDescription selectedTemplate;
    private GridData gridTable;

    public SelectModelTemplateComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createTemplatesViewer(this);
    }

    public void disable() {
        if (this.templateTableViewer != null) {
            this.templateTableViewer.getTable().setEnabled(false);
        }
    }

    private void createTemplatesViewer(Composite composite) {
        this.singleTemplateCombo = new ComboViewer(composite, 8);
        this.singleTemplateCombo.getControl().setLayoutData((Object)new GridData(4, 128, true, false));
        this.singleTemplateCombo.setContentProvider((IContentProvider)new ModelTemplatesContentProvider());
        this.singleTemplateCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModelTemplateDescription) {
                    ModelTemplateDescription currentTemplate = (ModelTemplateDescription)element;
                    return currentTemplate.getName();
                }
                return "";
            }
        });
        this.singleTemplateCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection template = (StructuredSelection)event.getSelection();
                if (template.getFirstElement() instanceof ModelTemplateDescription) {
                    SelectModelTemplateComposite.this.selectedTemplate = (ModelTemplateDescription)template.getFirstElement();
                } else if (template.getFirstElement() == UnsetObject.instance) {
                    SelectModelTemplateComposite.this.singleTemplateCombo.getCombo().clearSelection();
                    SelectModelTemplateComposite.this.singleTemplateCombo.setSelection(null);
                    SelectModelTemplateComposite.this.selectedTemplate = null;
                }
            }
        });
        this.templateTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)512);
        this.gridTable = new GridData(4, 128, true, false);
        this.templateTableViewer.getTable().setLayoutData((Object)this.gridTable);
        this.templateTableViewer.getTable().setBackground(composite.getBackground());
        this.templateTableViewer.setContentProvider((IContentProvider)new ModelTemplateTransfoProvider());
        this.templateTableViewer.setCheckStateProvider((ICheckStateProvider)new ModelTemplateCheckStateProvider());
        this.templateTableViewer.setLabelProvider((IBaseLabelProvider)new ModelTemplatesLabelProvider());
    }

    public String getTemplatePath() {
        if (this.selectedTemplate != null) {
            return this.selectedTemplate.getUml_path();
        }
        return null;
    }

    public String getDiTemplatePath() {
        if (this.selectedTemplate != null) {
            return this.selectedTemplate.getDi_path();
        }
        return null;
    }

    public String getNotationTemplatePath() {
        if (this.selectedTemplate != null) {
            return this.selectedTemplate.getNotation_path();
        }
        return null;
    }

    public String getTemplatePluginId() {
        if (this.selectedTemplate != null) {
            return this.selectedTemplate.getPluginId();
        }
        return null;
    }

    public void selectElement(Object toSelect) {
        if (this.templateTableViewer != null) {
            this.templateTableViewer.setCheckedElements(new Object[]{toSelect});
        }
    }

    public ModelTemplatesContentProvider getContentProvider() {
        if (this.templateTableViewer != null) {
            return (ModelTemplatesContentProvider)this.templateTableViewer.getContentProvider();
        }
        return null;
    }

    public List<ModelTemplateDescription> getTemplateTransfoPath() {
        Object[] selection;
        if (this.templateTableViewer != null && (selection = this.templateTableViewer.getCheckedElements()).length > 0) {
            ArrayList<ModelTemplateDescription> templatePath = new ArrayList<ModelTemplateDescription>();
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object currentObject = objectArray[n2];
                templatePath.add((ModelTemplateDescription)currentObject);
                ++n2;
            }
            return templatePath;
        }
        return new ArrayList<ModelTemplateDescription>();
    }

    public List<String> getDiTemplateTransfoPath() {
        ArrayList<String> diPathList = new ArrayList<String>();
        List<ModelTemplateDescription> templateTransfoPath = this.getTemplateTransfoPath();
        if (templateTransfoPath != null) {
            for (ModelTemplateDescription modelTemplateDescription : templateTransfoPath) {
                String diPath = modelTemplateDescription.getDi_path();
                if (diPath == null) continue;
                diPathList.add(diPath);
            }
        }
        return diPathList;
    }

    public List<String> getNotationTemplateTransfoPath() {
        ArrayList<String> notationPathList = new ArrayList<String>();
        List<ModelTemplateDescription> templateTransfoPath = this.getTemplateTransfoPath();
        if (templateTransfoPath != null) {
            for (ModelTemplateDescription modelTemplateDescription : templateTransfoPath) {
                String notationPath = modelTemplateDescription.getNotation_path();
                if (notationPath == null) continue;
                notationPathList.add(notationPath);
            }
        }
        return notationPathList;
    }

    public List<String> getTemplateTransfoPluginID() {
        ArrayList<String> pluginIdList = new ArrayList<String>();
        List<ModelTemplateDescription> templateTransfoPath = this.getTemplateTransfoPath();
        if (templateTransfoPath != null) {
            for (ModelTemplateDescription modelTemplateDescription : templateTransfoPath) {
                String pluginId = modelTemplateDescription.getPluginId();
                if (pluginId == null) continue;
                pluginIdList.add(pluginId);
            }
        }
        return pluginIdList;
    }

    public Combo getTemplateCombo() {
        return this.singleTemplateCombo.getCombo();
    }

    public void setInput(Object input) {
        if (this.templateTableViewer != null) {
            this.templateTableViewer.setInput(input);
        }
        this.singleTemplateCombo.setInput(input);
        int tableItemHeight = this.templateTableViewer.getTable().getItemHeight();
        int tableItemCount = ((ModelTemplateTransfoProvider)this.templateTableViewer.getContentProvider()).getElements(input).length;
        this.gridTable.minimumHeight = tableItemCount != 0 ? tableItemHeight * Math.max(1, Math.round(tableItemCount / 2)) : 0;
        this.gridTable.heightHint = tableItemCount != 0 ? tableItemHeight * Math.max(1, Math.round(tableItemCount / 2)) : 0;
        ((Composite)this.templateTableViewer.getControl()).layout(true, true);
    }
}

