/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.example.core.sashwindows.fulleditor.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.example.core.sashwindows.fulleditor.Activator;
import org.eclipse.papyrus.example.core.sashwindows.fulleditor.texteditor.TextEditorPartModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple.SimpleSashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.editor.AbstractMultiPageSashEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class MultiTextEditor
extends AbstractMultiPageSashEditor {
    IContentChangedListener contentChangedListener = new IContentChangedListener(){

        public void contentChanged(IContentChangedListener.ContentEvent event) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.sashwindows.fulleditor", "contentChanged()"));
            MultiTextEditor.this.refreshTabs();
        }
    };
    protected boolean isDirty = false;
    private IPropertyListener dirtyPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 257) {
                MultiTextEditor.this.isDirty = true;
            }
        }
    };

    public MultiTextEditor() {
        this.addPropertyListener(this.dirtyPropertyListener);
    }

    protected ISashWindowsContentProvider createPageProvider() {
        SimpleSashWindowsContentProvider pageProvider = new SimpleSashWindowsContentProvider();
        pageProvider.addPage((IPageModel)new TextEditorPartModel());
        pageProvider.addListener(this.contentChangedListener);
        return pageProvider;
    }

    protected SimpleSashWindowsContentProvider getContentProvider() {
        return (SimpleSashWindowsContentProvider)super.getContentProvider();
    }

    public void dispose() {
        this.getContentProvider().removeListener(this.contentChangedListener);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            editor.doSave(monitor);
            this.isDirty = false;
        }
    }

    public void doSaveAs() {
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            editor.doSaveAs();
            this.setInput(editor.getEditorInput());
            this.isDirty = false;
        }
    }

    public void gotoMarker(IMarker marker) {
        IDE.gotoMarker((IEditorPart)this.getActiveEditor(), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }
}

