/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDGateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionUse;

public class OLDCreateGateViewCommand
extends AbstractTransactionalCommand {
    protected IAdaptable containerViewAdapter;
    protected IAdaptable gateAdapter;
    private Point location;
    private ObjectAdapter resultAdapter = new ObjectAdapter();

    public OLDCreateGateViewCommand(TransactionalEditingDomain domain, IAdaptable containerViewAdapter, Point location, IAdaptable gateAdapter) {
        super(domain, "Create Gate", null);
        this.containerViewAdapter = containerViewAdapter;
        this.location = location;
        this.gateAdapter = gateAdapter;
        this.setResult(CommandResult.newOKCommandResult((Object)this.resultAdapter));
    }

    public List getAffectedFiles() {
        View containerView = this.getContainerView();
        if (containerView != null) {
            ArrayList<IFile> result = new ArrayList<IFile>();
            IFile file = WorkspaceSynchronizer.getFile((Resource)containerView.eResource());
            if (file != null) {
                result.add(file);
            }
            return result;
        }
        return super.getAffectedFiles();
    }

    protected View getContainerView() {
        if (this.containerViewAdapter != null) {
            return (View)this.containerViewAdapter.getAdapter(View.class);
        }
        return null;
    }

    public boolean canExecute() {
        if (this.getContainerView() == null) {
            return false;
        }
        return this.getGateAdapter() != null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View formalGateView;
        Gate formalGate;
        View interactionView;
        InteractionUse interactionUse;
        Interaction refersTo;
        Gate innerGate;
        if (!this.canExecute()) {
            return CommandResult.newCancelledCommandResult();
        }
        EObject parentElement = this.getParentElement();
        Gate gate = this.getGate();
        if (gate == null) {
            return CommandResult.newCancelledCommandResult();
        }
        View containerView = this.getContainerView();
        View view = GateHelper.createView(containerView, gate);
        if (view == null) {
            return CommandResult.newErrorCommandResult((String)"Unnable to create Gate.");
        }
        this.resultAdapter.setObject((Object)view);
        if (this.location != null) {
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)this.location.x);
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)this.location.y);
        }
        if (parentElement instanceof CombinedFragment && (innerGate = GateHelper.getInnerCFGate(gate)) != null) {
            View innerGateView = GateHelper.createView(containerView, innerGate);
            if (this.location != null) {
                ViewUtil.setStructuralFeatureValue((View)innerGateView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)this.location.x);
                ViewUtil.setStructuralFeatureValue((View)innerGateView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)(this.location.y + OLDGateEditPart.DEFAULT_SIZE.height + 2));
            }
        }
        if (parentElement instanceof InteractionUse && (refersTo = (interactionUse = (InteractionUse)parentElement).getRefersTo()) != null && (interactionView = this.findView(containerView.eResource(), refersTo)) != null && (formalGate = refersTo.getFormalGate(gate.getName())) != null && (formalGateView = GateHelper.createView(interactionView, formalGate)) != null) {
            boolean onRightSide = false;
            if (this.location != null) {
                Rectangle bounds = this.getBounds(containerView);
                onRightSide = this.location.x > bounds.getCenter().x;
            }
            this.assignLocation(interactionView, formalGateView, refersTo, formalGate, onRightSide);
        }
        return CommandResult.newOKCommandResult((Object)view);
    }

    private Gate getGate() {
        IAdaptable gateAdapter = this.getGateAdapter();
        if (gateAdapter != null) {
            return (Gate)gateAdapter.getAdapter(Gate.class);
        }
        return null;
    }

    protected EObject getParentElement() {
        View containerView = this.getContainerView();
        if (containerView == null) {
            return null;
        }
        return ViewUtil.resolveSemanticElement((View)containerView);
    }

    private Rectangle getBounds(View view) {
        int width = (Integer)this.getStructuralFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        int x = (Integer)this.getStructuralFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        String prefElementId = ViewUtil.resolveSemanticElement((View)view).eClass().getName();
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)view, (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)view, (String)prefElementId, (int)16);
        if (width <= 0) {
            width = store.getInt(preferenceConstantWitdh);
        }
        if (height <= 0) {
            height = store.getInt(preferenceConstantHeight);
        }
        return new Rectangle(x, y, width, height);
    }

    private void assignLocation(View interactionView, View formalGateView, Interaction interaction, Gate formalGate, boolean onRightSide) {
        Rectangle bounds = this.getBounds(interactionView);
        Point location = bounds.getLocation();
        int index = interaction.getFormalGates().indexOf((Object)formalGate);
        location.y = OLDGateEditPart.DEFAULT_SIZE.height * 2 * (index + 1);
        if (onRightSide) {
            location.x = bounds.right();
        }
        ViewUtil.setStructuralFeatureValue((View)formalGateView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)location.x);
        ViewUtil.setStructuralFeatureValue((View)formalGateView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)location.y);
    }

    private Object getStructuralFeatureValue(View view, EStructuralFeature feature) {
        return ViewUtil.getPropertyValue((View)view, (EStructuralFeature)feature, (EClass)feature.getEContainingClass());
    }

    private View findView(Resource eResource, Interaction interaction) {
        TreeIterator allContents = eResource.getResourceSet() != null ? EcoreUtil.getAllContents((ResourceSet)eResource.getResourceSet(), (boolean)true) : EcoreUtil.getAllContents((Resource)eResource, (boolean)true);
        while (allContents != null && allContents.hasNext()) {
            View view;
            Object next = allContents.next();
            if (!(next instanceof Shape) || interaction != ViewUtil.resolveSemanticElement((View)(view = (View)next))) continue;
            return view;
        }
        return null;
    }

    public IAdaptable getGateAdapter() {
        return this.gateAdapter;
    }

    public void setGateAdapter(IAdaptable gateAdapter) {
        this.gateAdapter = gateAdapter;
    }

    public IAdaptable getResult() {
        return this.resultAdapter;
    }
}

