/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.resource.index;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.index.AbstractUMLIndexHandler;
import org.xml.sax.Attributes;

public class ModelIndexHandler
extends AbstractUMLIndexHandler {
    private final Multimap<String, AbstractUMLIndexHandler.URIPair> packageProfileApplications = ArrayListMultimap.create();
    private String profileApplication;
    private String appliedProfile;
    private AbstractUMLIndexHandler.URIPair currentProfileApplication;

    public ModelIndexHandler(URI fileURI) {
        super(fileURI);
    }

    @Override
    public URI getFileURI() {
        return this.fileURI;
    }

    @Override
    protected void initializeUMLElementNames() {
        super.initializeUMLElementNames();
        this.profileApplication = "profileApplication";
        this.appliedProfile = "appliedProfile";
    }

    @Override
    protected boolean doHandleUMLElement(AbstractUMLIndexHandler.UMLElement element, Attributes attributes) {
        boolean result = false;
        if (element.isRole(this.profileApplication)) {
            this.currentProfileApplication = new AbstractUMLIndexHandler.URIPair();
            this.packageProfileApplications.put((Object)this.currentPackage.id, (Object)this.currentProfileApplication);
            this.await(this.appliedProfile);
            result = true;
        }
        return result;
    }

    @Override
    protected void handleAwaitedElement(AbstractUMLIndexHandler.UMLElement element) {
        URI href;
        if (element.isRole(this.appliedProfile) && (href = element.getHREF()) != null) {
            this.currentProfileApplication.first = href;
        }
    }

    @Override
    protected void handleAnnotationReferences(AbstractUMLIndexHandler.UMLElement references) {
        URI href = references.getHREF();
        if (href != null) {
            this.currentProfileApplication.second = href;
        }
    }

    @Override
    protected void summarize() {
        for (String packageID : this.packageProfileApplications.keySet()) {
            URI applyingPackageURI = this.fileURI.appendFragment(packageID);
            Collection profileApplications = this.packageProfileApplications.get((Object)packageID);
            if (profileApplications.isEmpty()) continue;
            HashMap map = this.getProfileApplicationsByPackage().get(applyingPackageURI.toString());
            if (map == null) {
                map = Maps.newHashMap();
                this.getProfileApplicationsByPackage().put(applyingPackageURI.toString(), map);
            }
            for (AbstractUMLIndexHandler.URIPair profileApplication : profileApplications) {
                if (profileApplication.second == null) continue;
                map.put(profileApplication.first.toString(), profileApplication.second.toString());
            }
        }
    }
}

