/**
 * Copyright (c) 2007, 2014 , 2021 Borland Software Corporation, Montages, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Michael Golubev (Montages) - API extracted to GMF-T runtime, migrated to Xtend2
 * Anatoliy Tischenko - Initial API and implementation
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.expressions;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class ExpressionAbstractExpression {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private Activator xptActivator;
  
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _abstractExpressionClassName = it.getEditorGen().getExpressionProviders().getAbstractExpressionClassName();
    _builder.append(_abstractExpressionClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _expressionsPackageName = it.getEditorGen().getExpressionProviders().getExpressionsPackageName();
    _builder.append(_expressionsPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence ExpressionAbstractExpression(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public abstract class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("{");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _status = this.status(it);
    _builder.append(_status, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _body = this.body(it);
    _builder.append(_body, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _context = this.context(it);
    _builder.append(_context, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _evaluate = this.evaluate(it);
    _builder.append(_evaluate, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _performCast = this.performCast(it);
    _builder.append(_performCast, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence status(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.core.runtime.IStatus status = org.eclipse.core.runtime.Status.OK_STATUS;\t");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setStatus(int severity, String message, Throwable throwable) {\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String pluginID = ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".ID;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.status = new org.eclipse.core.runtime.Status(severity, pluginID, -1, (message != null) ? message : \"\", throwable); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if(!this.status.isOK()) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(".getInstance().logError(\"Expression problem:\" + message + \"body:\"+ body(), throwable); ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t\t");
    _builder.append(" ");
    CharSequence _nonNLS_2 = this._common.nonNLS(2);
    _builder.append(_nonNLS_2, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.core.runtime.IStatus getStatus() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return status;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence body(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private final String myBody;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public String body() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myBody;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence context(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private final org.eclipse.emf.ecore.EClassifier myContext;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.emf.ecore.EClassifier context() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myContext;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constructor(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(String body, org.eclipse.emf.ecore.EClassifier context) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("myBody = body;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myContext = context;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence evaluate(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("@SuppressWarnings(\"rawtypes\")");
    _builder.newLine();
    _builder.append("protected abstract Object doEvaluate(Object context, java.util.Map env);");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public Object evaluate(Object context) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return evaluate(context, java.util.Collections.EMPTY_MAP);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("@SuppressWarnings(\"rawtypes\")");
    _builder.newLine();
    _builder.append("public Object evaluate(Object context, java.util.Map env) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(context().isInstance(context)) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return doEvaluate(context, env);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch(Exception e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t\t");
    _builder.append(".getInstance().logError(\"Expression evaluation failure: \" + body(), e); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence performCast(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment("Expression may return number value which is not directly compatible with feature type (e.g. Double when Integer is expected), or EEnumLiteral meta-object when literal instance is expected");
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static Object performCast(Object value, org.eclipse.emf.ecore.EDataType targetType) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (targetType instanceof org.eclipse.emf.ecore.EEnum) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (value instanceof org.eclipse.emf.ecore.EEnumLiteral) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.EEnumLiteral literal = (org.eclipse.emf.ecore.EEnumLiteral) value;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return (literal.getInstance() != null) ? literal.getInstance() : literal;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (false == value instanceof Number || targetType == null || targetType.getInstanceClass() == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return value;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Class<?> targetClass = targetType.getInstanceClass();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Number num = (Number) value;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Class<?> valClass = value.getClass();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Class<?> targetWrapperClass = targetClass;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (targetClass.isPrimitive()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("targetWrapperClass = org.eclipse.emf.ecore.util.EcoreUtil.wrapperClassFor(targetClass);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (valClass.equals(targetWrapperClass)) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return value;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (Number.class.isAssignableFrom(targetWrapperClass)) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Byte.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return Byte.valueOf(num.byteValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Integer.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return Integer.valueOf(num.intValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Short.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return Short.valueOf(num.shortValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Long.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return Long.valueOf(num.longValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(java.math.BigInteger.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return java.math.BigInteger.valueOf(num.longValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Float.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return Float.valueOf(num.floatValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Double.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return Double.valueOf(num.doubleValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(java.math.BigDecimal.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new java.math.BigDecimal(num.doubleValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return value;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
