/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.newchild.internal.checkers;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.CreationMenu;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.ElementCreationMenuModelPackage;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.ElementTypeConfigurationsIndex;

public class NewChildCustomValidator
extends CustomModelChecker.SwitchValidator {
    public NewChildCustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(CreationMenu creationMenu, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.validateCreationMenuRole(creationMenu, diagnostics, context);
    }

    private void validateCreationMenuRole(CreationMenu creationMenu, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String role = creationMenu.getRole();
        ElementTypeConfiguration type = creationMenu.getElementType();
        if (!(role == null || role.isBlank() || type == null || type.eIsProxy() || ElementTypeConfigurationsIndex.getInstance().isCreatableInRole(type, role))) {
            String label = creationMenu.getLabel();
            if (label == null || label.isBlank()) {
                label = type.getName();
            }
            diagnostics.add(this.createDiagnostic(2, (EObject)creationMenu, (EStructuralFeature)ElementCreationMenuModelPackage.Literals.CREATION_MENU__ROLE, this.format("No element type seems to have a role ''{1}'' that can create a ''{0}''.", context, new Object[]{label, role})));
        }
    }
}

